/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.runtime.logging.JBossVersion;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import io.quarkus.test.junit.launcher.ArtifactLauncherProvider;
import io.quarkus.test.junit.main.Launch;
import io.quarkus.test.junit.main.LaunchResult;
import io.quarkus.test.junit.main.QuarkusMainLauncher;
import io.quarkus.test.junit.util.CloseAdaptor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class QuarkusMainIntegrationTestExtension
extends AbstractQuarkusTestWithContextExtension
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"io.quarkus.test.main.integration"});
    private static Map<String, String> devServicesProps;
    ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;
    Properties quarkusArtifactProperties;
    LaunchResult result;

    public void beforeEach(ExtensionContext context) throws Exception {
        Launch launch = context.getRequiredTestMethod().getAnnotation(Launch.class);
        if (launch != null) {
            String[] arguments = launch.value();
            LaunchResult r = this.doLaunch(context, arguments);
            Assertions.assertEquals((int)launch.exitCode(), (int)r.exitCode(), (String)"Exit code did not match");
            this.result = r;
        }
    }

    private LaunchResult doLaunch(ExtensionContext context, String[] arguments) throws Exception {
        JBossVersion.disableVersionLogging();
        if (this.quarkusArtifactProperties == null) {
            this.prepare(context);
        }
        final ArtifactLauncher.LaunchResult result = this.doProcessStart(context, arguments);
        final List<String> out = Arrays.asList(new String(result.getOutput(), StandardCharsets.UTF_8).split("\n"));
        final List<String> err = Arrays.asList(new String(result.getStderror(), StandardCharsets.UTF_8).split("\n"));
        return new LaunchResult(){

            @Override
            public List<String> getOutputStream() {
                return out;
            }

            @Override
            public List<String> getErrorStream() {
                return err;
            }

            @Override
            public int exitCode() {
                return result.getStatusCode();
            }
        };
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.result = null;
    }

    private void prepare(ExtensionContext extensionContext) throws Exception {
        this.quarkusArtifactProperties = IntegrationTestUtil.readQuarkusArtifactProperties(extensionContext);
        String artifactType = this.quarkusArtifactProperties.getProperty("type");
        if (artifactType == null) {
            throw new IllegalStateException("Unable to determine the type of artifact created by the Quarkus build");
        }
        boolean isDockerLaunch = "jar-container".equals(artifactType) || "native-container".equals(artifactType);
        ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult = IntegrationTestUtil.handleDevServices(extensionContext, isDockerLaunch);
        devServicesProps = devServicesLaunchResult.properties();
        ExtensionContext root = extensionContext.getRoot();
        root.getStore(NAMESPACE).put((Object)"devServicesLaunchResult", (Object)new CloseAdaptor((AutoCloseable)devServicesLaunchResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArtifactLauncher.LaunchResult doProcessStart(ExtensionContext context, String[] args) {
        try {
            Class<? extends QuarkusTestProfile> profile = IntegrationTestUtil.findProfile(context.getRequiredTestClass());
            TestResourceManager testResourceManager = null;
            HashMap<String, String> old = new HashMap<String, String>();
            String artifactType = this.quarkusArtifactProperties.getProperty("type");
            try {
                void var13_18;
                Class requiredTestClass = context.getRequiredTestClass();
                Map<String, String> sysPropRestore = IntegrationTestUtil.getSysPropsToRestore();
                TestProfileAndProperties testProfileAndProperties = IntegrationTestUtil.determineTestProfileAndProperties(profile, sysPropRestore);
                testResourceManager = new TestResourceManager(requiredTestClass, profile, IntegrationTestUtil.getAdditionalTestResources(testProfileAndProperties.testProfile, context.getRequiredTestClass().getClassLoader()), testProfileAndProperties.testProfile != null && testProfileAndProperties.testProfile.disableGlobalTestResources());
                testResourceManager.init(testProfileAndProperties.testProfile != null ? testProfileAndProperties.testProfile.getClass().getName() : null);
                HashMap<String, String> additionalProperties = new HashMap<String, String>();
                Properties existingSysProps = System.getProperties();
                for (String string : existingSysProps.stringPropertyNames()) {
                    if (!string.startsWith("quarkus.")) continue;
                    additionalProperties.put(string, existingSysProps.getProperty(string));
                }
                additionalProperties.putAll(testProfileAndProperties.properties);
                HashMap<String, String> resourceManagerProps = new HashMap<String, String>(devServicesProps);
                resourceManagerProps.putAll(testResourceManager.start());
                for (Map.Entry entry : resourceManagerProps.entrySet()) {
                    old.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
                    if (entry.getValue() == null) {
                        System.clearProperty((String)entry.getKey());
                        continue;
                    }
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                additionalProperties.putAll(resourceManagerProps);
                testResourceManager.inject(context.getRequiredTestInstance());
                Object var13_16 = null;
                ServiceLoader<ArtifactLauncherProvider> serviceLoader = ServiceLoader.load(ArtifactLauncherProvider.class);
                for (ArtifactLauncherProvider artifactLauncherProvider : serviceLoader) {
                    if (!artifactLauncherProvider.supportsArtifactType(artifactType)) continue;
                    ArtifactLauncher<? extends ArtifactLauncher.InitContext> artifactLauncher = artifactLauncherProvider.create(new DefaultArtifactLauncherCreateContext(this.quarkusArtifactProperties, context, requiredTestClass, this.devServicesLaunchResult));
                    break;
                }
                if (var13_18 == null) {
                    throw new IllegalStateException("Artifact type + '" + artifactType + "' is not supported by @QuarkusMainIntegrationTest");
                }
                var13_18.includeAsSysProps(additionalProperties);
                IntegrationTestUtil.activateLogging();
                ArtifactLauncher.LaunchResult launchResult = var13_18.runToCompletion(args);
                return launchResult;
            }
            finally {
                for (Map.Entry entry : old.entrySet()) {
                    old.put((String)entry.getKey(), System.getProperty((String)entry.getKey()));
                    if (entry.getValue() == null) {
                        System.clearProperty((String)entry.getKey());
                        continue;
                    }
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                try {
                    if (testResourceManager != null) {
                        testResourceManager.close();
                    }
                }
                catch (Exception exception) {
                    System.err.println("Unable to shutdown resource: " + exception.getMessage());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        return type == LaunchResult.class || type == QuarkusMainLauncher.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, final ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> type = parameterContext.getParameter().getType();
        if (type == LaunchResult.class) {
            return this.result;
        }
        if (type == QuarkusMainLauncher.class) {
            return new QuarkusMainLauncher(){

                @Override
                public LaunchResult launch(String ... args) {
                    try {
                        return QuarkusMainIntegrationTestExtension.this.doLaunch(extensionContext, args);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }
        throw new RuntimeException("Parameter type not supported");
    }

    private static class DefaultArtifactLauncherCreateContext
    implements ArtifactLauncherProvider.CreateContext {
        private final Properties quarkusArtifactProperties;
        private final ExtensionContext context;
        private final Class<?> requiredTestClass;
        private final ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult;

        DefaultArtifactLauncherCreateContext(Properties quarkusArtifactProperties, ExtensionContext context, Class<?> requiredTestClass, ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult) {
            this.quarkusArtifactProperties = quarkusArtifactProperties;
            this.context = context;
            this.requiredTestClass = requiredTestClass;
            this.devServicesLaunchResult = devServicesLaunchResult;
        }

        @Override
        public Properties quarkusArtifactProperties() {
            return this.quarkusArtifactProperties;
        }

        @Override
        public Path buildOutputDirectory() {
            return IntegrationTestUtil.determineBuildOutputDirectory(this.context);
        }

        @Override
        public Class<?> testClass() {
            return this.requiredTestClass;
        }

        @Override
        public ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult() {
            return this.devServicesLaunchResult;
        }
    }
}

