/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.mockito.InjectMock;
import io.quarkus.test.junit.mockito.MockitoConfig;
import io.quarkus.test.junit.mockito.internal.MockitoMocksTracker;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Optional;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class CreateMockitoMocksCallback
implements QuarkusTestAfterConstructCallback {
    public void afterConstruct(Object testInstance) {
        Class<?> current = testInstance.getClass();
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                InjectMock deprecatedInjectMock = field.getAnnotation(InjectMock.class);
                if (deprecatedInjectMock != null) {
                    boolean returnsDeepMocks = deprecatedInjectMock.returnsDeepMocks();
                    this.injectField(testInstance, field, InjectMock.class, returnsDeepMocks);
                    continue;
                }
                io.quarkus.test.InjectMock injectMock = field.getAnnotation(io.quarkus.test.InjectMock.class);
                if (injectMock == null) continue;
                MockitoConfig config = field.getAnnotation(MockitoConfig.class);
                boolean returnsDeepMocks = config != null ? config.returnsDeepMocks() : false;
                this.injectField(testInstance, field, io.quarkus.test.InjectMock.class, returnsDeepMocks);
            }
            current = current.getSuperclass();
        }
    }

    private void injectField(Object testInstance, Field field, Class<? extends Annotation> annotationType, boolean returnsDeepMocks) {
        InstanceHandle<?> beanHandle = CreateMockitoMocksCallback.getBeanHandle(testInstance, field, annotationType);
        Optional<Object> result = this.createMockAndSetTestField(testInstance, field, beanHandle, new MockConfiguration(returnsDeepMocks));
        if (result.isPresent()) {
            MockitoMocksTracker.track(testInstance, result.get(), beanHandle.get());
        }
    }

    private Optional<Object> createMockAndSetTestField(Object testInstance, Field field, InstanceHandle<?> beanHandle, MockConfiguration mockConfiguration) {
        boolean isNew;
        Object mock;
        Class implementationClass = beanHandle.getBean().getImplementationClass();
        Optional<Object> currentMock = MockitoMocksTracker.currentMock(testInstance, beanHandle.get());
        if (currentMock.isPresent()) {
            mock = currentMock.get();
            isNew = false;
        } else {
            mock = mockConfiguration.useDeepMocks ? Mockito.mock((Class)implementationClass, (Answer)Mockito.RETURNS_DEEP_STUBS) : Mockito.mock((Class)implementationClass);
            isNew = true;
        }
        field.setAccessible(true);
        try {
            field.set(testInstance, mock);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (isNew) {
            return Optional.of(mock);
        }
        return Optional.empty();
    }

    static InstanceHandle<?> getBeanHandle(Object testInstance, Field field, Class<? extends Annotation> annotationType) {
        BeanManager beanManager;
        Annotation[] qualifiers;
        Type fieldType = field.getGenericType();
        ArcContainer container = Arc.container();
        InstanceHandle handle = container.instance(fieldType, qualifiers = CreateMockitoMocksCallback.getQualifiers(field, beanManager = container.beanManager()));
        if (!handle.isAvailable()) {
            throw new IllegalStateException("Invalid use of " + annotationType.getTypeName() + " - could not resolve the bean of type: " + fieldType.getTypeName() + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        if (!beanManager.isNormalScope(handle.getBean().getScope())) {
            throw new IllegalStateException("Invalid use of " + annotationType.getTypeName() + " - the injected bean does not declare a CDI normal scope but: " + handle.getBean().getScope().getName() + ". Offending field is " + field.getName() + " of test class " + testInstance.getClass());
        }
        return handle;
    }

    static Annotation[] getQualifiers(Field fieldToMock, BeanManager beanManager) {
        Annotation[] fieldAnnotations;
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        for (Annotation fieldAnnotation : fieldAnnotations = fieldToMock.getDeclaredAnnotations()) {
            if (!beanManager.isQualifier(fieldAnnotation.annotationType())) continue;
            qualifiers.add(fieldAnnotation);
        }
        return qualifiers.toArray(new Annotation[0]);
    }

    private static class MockConfiguration {
        final boolean useDeepMocks;

        private MockConfiguration(boolean useDeepMocks) {
            this.useDeepMocks = useDeepMocks;
        }
    }
}

