/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.component;

import io.quarkus.arc.ComponentsProvider;
import io.quarkus.arc.ResourceReferenceProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;

class QuarkusComponentTestClassLoader
extends ClassLoader {
    private final File componentsProviderFile;
    private final File resourceReferenceProviderFile;

    public QuarkusComponentTestClassLoader(ClassLoader parent, File componentsProviderFile, File resourceReferenceProviderFile) {
        super(parent);
        this.componentsProviderFile = Objects.requireNonNull(componentsProviderFile);
        this.resourceReferenceProviderFile = resourceReferenceProviderFile;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (("META-INF/services/" + ComponentsProvider.class.getName()).equals(name)) {
            return Collections.enumeration(Collections.singleton(this.componentsProviderFile.toURI().toURL()));
        }
        if (this.resourceReferenceProviderFile != null && ("META-INF/services/" + ResourceReferenceProvider.class.getName()).equals(name)) {
            return Collections.enumeration(Collections.singleton(this.resourceReferenceProviderFile.toURI().toURL()));
        }
        return super.getResources(name);
    }
}

