/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jfr.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.jfr.runtime.JfrRecorder;
import io.quarkus.jfr.runtime.OTelIdProducer;
import io.quarkus.jfr.runtime.QuarkusIdProducer;
import io.quarkus.jfr.runtime.config.JfrRuntimeConfig;
import io.quarkus.jfr.runtime.http.rest.classic.ClassicServerFilter;
import io.quarkus.jfr.runtime.http.rest.classic.ClassicServerRecorderProducer;
import io.quarkus.jfr.runtime.http.rest.reactive.ReactiveServerFilters;
import io.quarkus.jfr.runtime.http.rest.reactive.ReactiveServerRecorderProducer;
import io.quarkus.jfr.runtime.http.rest.reactive.ServerStartRecordingHandler;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.server.spi.GlobalHandlerCustomizerBuildItem;
import io.quarkus.resteasy.reactive.spi.CustomContainerRequestFilterBuildItem;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;

@BuildSteps
public class JfrProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.JFR);
    }

    @BuildStep
    void registerRequestIdProducer(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItem) {
        if (capabilities.isPresent("io.quarkus.opentelemetry.tracer")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{OTelIdProducer.class}).build());
        } else {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{QuarkusIdProducer.class}).build());
            runtimeInitializedClassBuildItem.produce((BuildItem)new RuntimeInitializedClassBuildItem(QuarkusIdProducer.class.getCanonicalName()));
        }
    }

    @BuildStep
    void registerRestIntegration(Capabilities capabilities, BuildProducer<CustomContainerRequestFilterBuildItem> filterBeans, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GlobalHandlerCustomizerBuildItem> globalHandlerCustomizerProducer) {
        if (capabilities.isPresent("io.quarkus.resteasy.reactive")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{ReactiveServerRecorderProducer.class}).build());
            filterBeans.produce((BuildItem)new CustomContainerRequestFilterBuildItem(ReactiveServerFilters.class.getName()));
            globalHandlerCustomizerProducer.produce((BuildItem)new GlobalHandlerCustomizerBuildItem((HandlerChainCustomizer)new ServerStartRecordingHandler.Customizer()));
        }
    }

    @BuildStep
    void registerResteasyClassicIntegration(Capabilities capabilities, BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isPresent("io.quarkus.resteasy")) {
            additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{ClassicServerRecorderProducer.class}).build());
            resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(ClassicServerFilter.class.getName()));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void runtimeInit(JfrRecorder recorder, JfrRuntimeConfig runtimeConfig) {
        recorder.runtimeInit(runtimeConfig);
    }
}

