/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.infinispan.client.runtime.InfinispanClientBuildTimeConfig;
import io.quarkus.infinispan.client.runtime.InfinispanClientUtil;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
@ConfigMapping(prefix="quarkus.infinispan-client")
public interface InfinispanClientsBuildTimeConfig {
    @WithParentName
    public InfinispanClientBuildTimeConfig defaultInfinispanClient();

    @WithParentName
    @ConfigDocMapKey(value="client-name")
    @ConfigDocSection
    public Map<String, InfinispanClientBuildTimeConfig> namedInfinispanClients();

    @WithName(value="health.enabled")
    @WithDefault(value="true")
    public boolean healthEnabled();

    default public Set<String> getInfinispanNamedClientConfigNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.namedInfinispanClients().keySet()));
    }

    default public InfinispanClientBuildTimeConfig getInfinispanClientBuildTimeConfig(String infinispanClientName) {
        if (InfinispanClientUtil.isDefault(infinispanClientName)) {
            return this.defaultInfinispanClient();
        }
        return this.namedInfinispanClients().get(infinispanClientName);
    }
}

