/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.jaxrs;

import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyReactiveViolationException;
import io.quarkus.hibernate.validator.runtime.jaxrs.ValidatorMediaTypeUtil;
import io.quarkus.hibernate.validator.runtime.jaxrs.ViolationReport;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ElementKind;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.validator.path.RandomAccessPath;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;

@Provider
public class ResteasyReactiveViolationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final String VALIDATION_HEADER = "validation-exception";

    public Response toResponse(ValidationException exception) {
        if (!(exception instanceof ResteasyReactiveViolationException)) {
            throw exception;
        }
        ResteasyReactiveViolationException resteasyViolationException = (ResteasyReactiveViolationException)exception;
        if (this.hasReturnValueViolation(resteasyViolationException.getConstraintViolations())) {
            throw resteasyViolationException;
        }
        return this.buildViolationReportResponse(resteasyViolationException);
    }

    private boolean hasReturnValueViolation(Set<ConstraintViolation<?>> violations) {
        if (violations != null) {
            for (ConstraintViolation<?> violation : violations) {
                if (!this.isReturnValueViolation(violation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isReturnValueViolation(ConstraintViolation<?> violation) {
        Path path = violation.getPropertyPath();
        if (path instanceof RandomAccessPath) {
            RandomAccessPath randomAccessPath = (RandomAccessPath)path;
            return randomAccessPath.getRootNode().getKind() == ElementKind.METHOD && randomAccessPath.getNode(1).getKind() == ElementKind.RETURN_VALUE;
        }
        Iterator nodes = violation.getPropertyPath().iterator();
        Path.Node firstNode = (Path.Node)nodes.next();
        if (firstNode.getKind() != ElementKind.METHOD) {
            return false;
        }
        Path.Node secondNode = (Path.Node)nodes.next();
        return secondNode.getKind() == ElementKind.RETURN_VALUE;
    }

    private Response buildViolationReportResponse(ConstraintViolationException cve) {
        Response.Status status = Response.Status.BAD_REQUEST;
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        builder.header(VALIDATION_HEADER, (Object)"true");
        ResteasyReactiveRequestContext rrContext = CurrentRequestManager.get();
        MediaType mediaType = ValidatorMediaTypeUtil.getAcceptMediaType(rrContext.getHttpHeaders().getAcceptableMediaTypes(), this.serverMediaTypes(rrContext));
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_JSON_TYPE;
        }
        ArrayList<ViolationReport.Violation> violationsInReport = new ArrayList<ViolationReport.Violation>(cve.getConstraintViolations().size());
        for (ConstraintViolation cv : cve.getConstraintViolations()) {
            violationsInReport.add(new ViolationReport.Violation(cv.getPropertyPath().toString(), cv.getMessage()));
        }
        builder.entity((Object)new ViolationReport("Constraint Violation", status, violationsInReport));
        builder.type(mediaType);
        return builder.build();
    }

    private List<MediaType> serverMediaTypes(ResteasyReactiveRequestContext context) {
        if (context.getTarget() == null) {
            return ValidatorMediaTypeUtil.SUPPORTED_MEDIA_TYPES;
        }
        ServerMediaType serverMediaType = context.getTarget().getProduces();
        if (serverMediaType == null) {
            return ValidatorMediaTypeUtil.SUPPORTED_MEDIA_TYPES;
        }
        return Arrays.asList(serverMediaType.getSortedMediaTypes());
    }
}

