/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import io.quarkus.hibernate.orm.runtime.proxies.ProxyDefinitions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyConfiguration;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.bytebuddy.ByteBuddyInterceptor;
import org.hibernate.type.CompositeType;

public final class QuarkusProxyFactory
implements ProxyFactory {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(QuarkusProxyFactory.class);
    private final ProxyDefinitions proxyClassDefinitions;
    private Class<?> persistentClass;
    private String entityName;
    private Class<?>[] interfaces;
    private Method getIdentifierMethod;
    private Method setIdentifierMethod;
    private CompositeType componentIdType;
    private boolean overridesEquals;
    private Constructor constructor;

    public QuarkusProxyFactory(ProxyDefinitions proxyClassDefinitions) {
        this.proxyClassDefinitions = proxyClassDefinitions;
    }

    public void postInstantiate(String entityName, Class<?> persistentClass, Set<Class<?>> interfaces, Method getIdentifierMethod, Method setIdentifierMethod, CompositeType componentIdType) throws HibernateException {
        this.entityName = entityName;
        this.persistentClass = persistentClass;
        this.interfaces = QuarkusProxyFactory.toArray(interfaces);
        this.getIdentifierMethod = getIdentifierMethod;
        this.setIdentifierMethod = setIdentifierMethod;
        this.componentIdType = componentIdType;
        ProxyDefinitions.ProxyClassDetailsHolder detailsHolder = this.proxyClassDefinitions.getProxyForClass(persistentClass);
        if (detailsHolder == null) {
            String reason = null;
            if (persistentClass.getName().startsWith("org.hibernate.")) {
                reason = "this is a limitation of this particular Hibernate class.";
            } else if (Modifier.isFinal(persistentClass.getModifiers())) {
                reason = "this class is final. Your application might perform better if this class was non-final.";
            }
            if (reason != null) {
                throw new HibernateException(String.format(Locale.ROOT, "Could not lookup a pre-generated proxy class definition for entity '%s' (class='%s'): %s", entityName, persistentClass.getCanonicalName(), reason));
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "Could not lookup a pre-generated proxy class definition for entity '%s' (class='%s').This should not happen, please open an issue at https://github.com/quarkusio/quarkus/issues", entityName, persistentClass.getCanonicalName()));
        }
        this.overridesEquals = detailsHolder.isOverridesEquals();
        this.constructor = detailsHolder.getConstructor();
    }

    private static Class<?>[] toArray(Set<Class<?>> interfaces) {
        if (interfaces == null) {
            return ArrayHelper.EMPTY_CLASS_ARRAY;
        }
        return interfaces.toArray(new Class[interfaces.size()]);
    }

    public HibernateProxy getProxy(Object id, SharedSessionContractImplementor session) throws HibernateException {
        ByteBuddyInterceptor interceptor = new ByteBuddyInterceptor(this.entityName, this.persistentClass, (Class[])this.interfaces, id, this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType, session, this.overridesEquals);
        try {
            HibernateProxy proxy = (HibernateProxy)this.constructor.newInstance(new Object[0]);
            ((ProxyConfiguration)proxy).$$_hibernate_set_interceptor((ProxyConfiguration.Interceptor)interceptor);
            return proxy;
        }
        catch (Throwable t) {
            String logMessage = "Bytecode enhancement failed for class '" + this.entityName + "' (it might be due to the Java module system preventing Hibernate ORM from defining an enhanced class in the same package - in this case, the class should be opened and exported to Hibernate ORM)";
            LOG.error((Object)logMessage, t);
            throw new HibernateException(logMessage, t);
        }
    }
}

