/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.rest.data.panache.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.hibernate.orm.rest.data.panache.PanacheEntityResource;
import io.quarkus.hibernate.orm.rest.data.panache.PanacheRepositoryResource;
import io.quarkus.hibernate.orm.rest.data.panache.RestDataResourceMethodListener;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.EntityClassHelper;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.EntityDataAccessImplementor;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.RepositoryDataAccessImplementor;
import io.quarkus.hibernate.orm.rest.data.panache.deployment.ResourceImplementor;
import io.quarkus.hibernate.orm.rest.data.panache.runtime.RestDataPanacheExceptionMapper;
import io.quarkus.hibernate.orm.rest.data.panache.runtime.jta.TransactionalUpdateExecutor;
import io.quarkus.rest.data.panache.RestDataPanacheException;
import io.quarkus.rest.data.panache.deployment.ResourceMetadata;
import io.quarkus.rest.data.panache.deployment.ResourceMethodListenerBuildItem;
import io.quarkus.rest.data.panache.deployment.RestDataResourceBuildItem;
import io.quarkus.rest.data.panache.deployment.utils.EntityTypeUtils;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import java.lang.reflect.Modifier;
import java.util.List;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

class HibernateOrmPanacheRestProcessor {
    private static final DotName PANACHE_ENTITY_RESOURCE_INTERFACE = DotName.createSimple((String)PanacheEntityResource.class.getName());
    private static final DotName PANACHE_REPOSITORY_RESOURCE_INTERFACE = DotName.createSimple((String)PanacheRepositoryResource.class.getName());
    private static final DotName REST_DATA_RESOURCE_METHOD_LISTENER_INTERFACE = DotName.createSimple((String)RestDataResourceMethodListener.class.getName());

    HibernateOrmPanacheRestProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.HIBERNATE_ORM_REST_DATA_PANACHE);
    }

    @BuildStep
    void findResourceMethodListeners(CombinedIndexBuildItem index, BuildProducer<ResourceMethodListenerBuildItem> resourceMethodListeners) {
        for (ClassInfo classInfo : index.getIndex().getKnownDirectImplementors(REST_DATA_RESOURCE_METHOD_LISTENER_INTERFACE)) {
            List<Type> generics = this.getGenericTypes(classInfo);
            Type entityType = generics.get(0);
            resourceMethodListeners.produce((BuildItem)new ResourceMethodListenerBuildItem(classInfo, entityType));
        }
    }

    @BuildStep
    void registerRestDataPanacheExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> resteasyJaxrsProviderBuildItemBuildProducer, BuildProducer<ExceptionMapperBuildItem> exceptionMapperBuildItemBuildProducer) {
        resteasyJaxrsProviderBuildItemBuildProducer.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RestDataPanacheExceptionMapper.class.getName()));
        exceptionMapperBuildItemBuildProducer.produce((BuildItem)new ExceptionMapperBuildItem(RestDataPanacheExceptionMapper.class.getName(), RestDataPanacheException.class.getName(), Integer.valueOf(5100), false));
    }

    @BuildStep
    AdditionalBeanBuildItem registerTransactionalExecutor() {
        return AdditionalBeanBuildItem.unremovableOf(TransactionalUpdateExecutor.class);
    }

    @BuildStep
    void findEntityResources(CombinedIndexBuildItem index, List<ResourceMethodListenerBuildItem> resourceMethodListeners, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer) {
        ResourceImplementor resourceImplementor = new ResourceImplementor(new EntityClassHelper(index.getComputingIndex()));
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        for (ClassInfo classInfo : index.getComputingIndex().getKnownDirectImplementors(PANACHE_ENTITY_RESOURCE_INTERFACE)) {
            this.validateResource(index.getComputingIndex(), classInfo);
            List<Type> generics = this.getGenericTypes(classInfo);
            String resourceInterface = classInfo.name().toString();
            String entityType = generics.get(0).name().toString();
            String idType = generics.get(1).name().toString();
            List listenersForEntityType = EntityTypeUtils.getListenersByEntityType((IndexView)index.getIndex(), resourceMethodListeners, (String)entityType);
            EntityDataAccessImplementor dataAccessImplementor = new EntityDataAccessImplementor(entityType);
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, dataAccessImplementor, resourceInterface, entityType, listenersForEntityType);
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, resourceInterface, entityType, idType, EntityTypeUtils.getEntityFields((IndexView)index.getIndex(), (String)entityType))));
        }
    }

    @BuildStep
    void findRepositoryResources(CombinedIndexBuildItem index, List<ResourceMethodListenerBuildItem> resourceMethodListeners, BuildProducer<GeneratedBeanBuildItem> implementationsProducer, BuildProducer<RestDataResourceBuildItem> restDataResourceProducer, BuildProducer<UnremovableBeanBuildItem> unremovableBeansProducer) {
        ResourceImplementor resourceImplementor = new ResourceImplementor(new EntityClassHelper(index.getComputingIndex()));
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(implementationsProducer);
        for (ClassInfo classInfo : index.getComputingIndex().getKnownDirectImplementors(PANACHE_REPOSITORY_RESOURCE_INTERFACE)) {
            this.validateResource(index.getComputingIndex(), classInfo);
            List<Type> generics = this.getGenericTypes(classInfo);
            String resourceInterface = classInfo.name().toString();
            String repositoryClassName = generics.get(0).name().toString();
            String entityType = generics.get(1).name().toString();
            String idType = generics.get(2).name().toString();
            List listenersForEntityType = EntityTypeUtils.getListenersByEntityType((IndexView)index.getIndex(), resourceMethodListeners, (String)entityType);
            RepositoryDataAccessImplementor dataAccessImplementor = new RepositoryDataAccessImplementor(repositoryClassName);
            String resourceClass = resourceImplementor.implement((ClassOutput)classOutput, dataAccessImplementor, resourceInterface, entityType, listenersForEntityType);
            unremovableBeansProducer.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(repositoryClassName)));
            restDataResourceProducer.produce((BuildItem)new RestDataResourceBuildItem(new ResourceMetadata(resourceClass, resourceInterface, entityType, idType, EntityTypeUtils.getEntityFields((IndexView)index.getIndex(), (String)entityType))));
        }
    }

    private void validateResource(IndexView index, ClassInfo classInfo) {
        if (!Modifier.isInterface(classInfo.flags())) {
            throw new RuntimeException(classInfo.name() + " has to be an interface");
        }
        if (classInfo.interfaceNames().size() > 1) {
            throw new RuntimeException(classInfo.name() + " should only extend REST Data Panache interface");
        }
        if (!index.getKnownDirectImplementors(classInfo.name()).isEmpty()) {
            throw new RuntimeException(classInfo.name() + " should not be extended or implemented");
        }
    }

    private List<Type> getGenericTypes(ClassInfo classInfo) {
        return ((Type)classInfo.interfaceTypes().stream().findFirst().orElseThrow(() -> new RuntimeException(classInfo.toString() + " does not have generic types"))).asParameterizedType().arguments();
    }
}

