/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.panache.common.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.panache.common.runtime.NamedQueryUtil;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.panache.common.Parameters;
import io.quarkus.panache.common.Sort;
import io.quarkus.panache.hibernate.common.runtime.PanacheJpaUtil;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.Session;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.SelectionQuery;

public abstract class AbstractJpaOperations<PanacheQueryType> {
    private static volatile Map<String, String> entityToPersistenceUnit = Collections.emptyMap();

    public static void setEntityToPersistenceUnit(Map<String, String> map) {
        entityToPersistenceUnit = Collections.unmodifiableMap(map);
    }

    protected abstract PanacheQueryType createPanacheQuery(Session var1, String var2, String var3, String var4, Object var5);

    public abstract List<?> list(PanacheQueryType var1);

    public abstract Stream<?> stream(PanacheQueryType var1);

    public EntityManager getEntityManager(Class<?> clazz) {
        return this.getSession(clazz);
    }

    public Session getSession(Class<?> clazz) {
        String clazzName = clazz.getName();
        String persistentUnitName = entityToPersistenceUnit.get(clazzName);
        return this.getSession(persistentUnitName);
    }

    public Session getSession(String persistentUnitName) {
        ArcContainer arcContainer = Arc.container();
        if (persistentUnitName == null || PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistentUnitName)) {
            InstanceHandle sessionHandle = arcContainer.instance(Session.class, new Annotation[0]);
            if (sessionHandle.isAvailable()) {
                return (Session)sessionHandle.get();
            }
            if (!arcContainer.instance(AgroalDataSource.class, new Annotation[0]).isAvailable()) {
                throw new IllegalStateException("The default datasource has not been properly configured. See https://quarkus.io/guides/datasource#jdbc-datasource for information on how to do that.");
            }
            throw new IllegalStateException("No entities were found. Did you forget to annotate your Panache Entity classes with '@Entity'?");
        }
        InstanceHandle sessionHandle = arcContainer.instance(Session.class, new Annotation[]{new PersistenceUnit.PersistenceUnitLiteral(persistentUnitName)});
        if (sessionHandle.isAvailable()) {
            return (Session)sessionHandle.get();
        }
        throw new IllegalStateException("No entities were attached to persistence unit '" + persistentUnitName + "'. Did you forget to annotate your Panache Entity classes with '@Entity' or improperly configure the 'quarkus.hibernate-orm.\" " + persistentUnitName + "\".packages' property?");
    }

    public Session getSession() {
        return this.getSession("<default>");
    }

    public void persist(Object entity) {
        Session session = this.getSession(entity.getClass());
        this.persist(session, entity);
    }

    public void persist(Session session, Object entity) {
        if (!session.contains(entity)) {
            session.persist(entity);
        }
    }

    public void persist(Iterable<?> entities) {
        for (Object entity : entities) {
            this.persist(this.getSession(entity.getClass()), entity);
        }
    }

    public void persist(Object firstEntity, Object ... entities) {
        this.persist(firstEntity);
        for (Object entity : entities) {
            this.persist(entity);
        }
    }

    public void persist(Stream<?> entities) {
        entities.forEach(entity -> this.persist(entity));
    }

    public void delete(Object entity) {
        Session session;
        session.remove((session = this.getSession(entity.getClass())).contains(entity) ? entity : session.getReference(entity));
    }

    public boolean isPersistent(Object entity) {
        return this.getSession(entity.getClass()).contains(entity);
    }

    public void flush() {
        this.getSession().flush();
    }

    public void flush(Object entity) {
        this.getSession(entity.getClass()).flush();
    }

    public void flush(Class<?> clazz) {
        this.getSession(clazz).flush();
    }

    public static TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    public static <T extends CommonQueryContract> T bindParameters(T query, Object[] params) {
        if (params == null || params.length == 0) {
            return query;
        }
        for (int i = 0; i < params.length; ++i) {
            query.setParameter(i + 1, params[i]);
        }
        return query;
    }

    public static <T extends CommonQueryContract> T bindParameters(T query, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return query;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query;
    }

    public int paramCount(Object[] params) {
        return params != null ? params.length : 0;
    }

    public int paramCount(Map<String, Object> params) {
        return params != null ? params.size() : 0;
    }

    public Object findById(Class<?> entityClass, Object id) {
        return this.getSession(entityClass).find(entityClass, id);
    }

    public Object findById(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return this.getSession(entityClass).find(entityClass, id, lockModeType);
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id) {
        return Optional.ofNullable(this.findById(entityClass, id));
    }

    public Optional<?> findByIdOptional(Class<?> entityClass, Object id, LockModeType lockModeType) {
        return Optional.ofNullable(this.findById(entityClass, id, lockModeType));
    }

    public PanacheQueryType find(Class<?> entityClass, String query, Object ... params) {
        return this.find(entityClass, query, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        Session session = this.getSession(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, panacheQuery, panacheQuery, null, params);
        }
        String translatedHqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(session, translatedHqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.find(entityClass, panacheQuery, null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        Session session = this.getSession(entityClass);
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            String namedQuery = panacheQuery.substring(1);
            if (sort != null) {
                throw new IllegalArgumentException("Sort cannot be used with named query, add an \"order by\" clause to the named query \"" + namedQuery + "\" instead");
            }
            NamedQueryUtil.checkNamedQuery(entityClass, namedQuery);
            return this.createPanacheQuery(session, panacheQuery, panacheQuery, null, params);
        }
        String translatedHqlQuery = PanacheJpaUtil.createFindQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
        return this.createPanacheQuery(session, translatedHqlQuery, panacheQuery, PanacheJpaUtil.toOrderBy((Sort)sort), params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.find(entityClass, panacheQuery, (Sort)null, params);
    }

    public PanacheQueryType find(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.find(entityClass, panacheQuery, sort, params.map());
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Object ... params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.list(this.find(entityClass, panacheQuery, params));
    }

    public List<?> list(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.list(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Object ... params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Object ... params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Map<String, Object> params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Parameters params) {
        return this.stream(this.find(entityClass, panacheQuery, params));
    }

    public Stream<?> stream(Class<?> entityClass, String panacheQuery, Sort sort, Parameters params) {
        return this.stream(this.find(entityClass, panacheQuery, sort, params));
    }

    public PanacheQueryType findAll(Class<?> entityClass) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Session session = this.getSession(entityClass);
        return this.createPanacheQuery(session, query, null, null, null);
    }

    public PanacheQueryType findAll(Class<?> entityClass, Sort sort) {
        String query = "FROM " + PanacheJpaUtil.getEntityName(entityClass);
        Session session = this.getSession(entityClass);
        return this.createPanacheQuery(session, query, null, PanacheJpaUtil.toOrderBy((Sort)sort), null);
    }

    public List<?> listAll(Class<?> entityClass) {
        return this.list(this.findAll(entityClass));
    }

    public List<?> listAll(Class<?> entityClass, Sort sort) {
        return this.list(this.findAll(entityClass, sort));
    }

    public Stream<?> streamAll(Class<?> entityClass) {
        return this.stream(this.findAll(entityClass));
    }

    public Stream<?> streamAll(Class<?> entityClass, Sort sort) {
        return this.stream(this.findAll(entityClass, sort));
    }

    public long count(Class<?> entityClass) {
        return this.getSession(entityClass).createSelectionQuery("FROM " + PanacheJpaUtil.getEntityName(entityClass), entityClass).getResultCount();
    }

    public long count(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            SelectionQuery<?> namedQuery = this.extractNamedSelectionQuery(entityClass, panacheQuery);
            return (Long)AbstractJpaOperations.bindParameters(namedQuery, params).getSingleResult();
        }
        try {
            String query = PanacheJpaUtil.createQueryForCount(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createSelectionQuery(query, Object.class), params).getResultCount();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long count(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            SelectionQuery<?> namedQuery = this.extractNamedSelectionQuery(entityClass, panacheQuery);
            return (Long)AbstractJpaOperations.bindParameters(namedQuery, params).getSingleResult();
        }
        try {
            String query = PanacheJpaUtil.createQueryForCount(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createSelectionQuery(query, Object.class), params).getResultCount();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long count(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params.map());
    }

    private SelectionQuery<?> extractNamedSelectionQuery(Class<?> entityClass, String query) {
        String namedQueryName = this.extractNamedQueryName(entityClass, query);
        return this.getSession(entityClass).createNamedSelectionQuery(namedQueryName);
    }

    private MutationQuery extractNamedMutationQuery(Class<?> entityClass, String query) {
        String namedQueryName = this.extractNamedQueryName(entityClass, query);
        return this.getSession(entityClass).createNamedMutationQuery(namedQueryName);
    }

    private String extractNamedQueryName(Class<?> entityClass, String query) {
        if (!PanacheJpaUtil.isNamedQuery((String)query)) {
            throw new IllegalArgumentException("Must be a named query!");
        }
        String namedQueryName = query.substring(1);
        NamedQueryUtil.checkNamedQuery(entityClass, namedQueryName);
        return namedQueryName;
    }

    public boolean exists(Class<?> entityClass) {
        return this.count(entityClass) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Object ... params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public boolean exists(Class<?> entityClass, String query, Parameters params) {
        return this.count(entityClass, query, params) > 0L;
    }

    public long deleteAll(Class<?> entityClass) {
        return this.getSession(entityClass).createMutationQuery("DELETE FROM " + PanacheJpaUtil.getEntityName(entityClass)).executeUpdate();
    }

    public boolean deleteById(Class<?> entityClass, Object id) {
        Object entity = this.findById(entityClass, id);
        if (entity == null) {
            return false;
        }
        this.getSession(entityClass).remove(entity);
        return true;
    }

    public long delete(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return AbstractJpaOperations.bindParameters(this.extractNamedMutationQuery(entityClass, panacheQuery), params).executeUpdate();
        }
        try {
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createMutationQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long delete(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return AbstractJpaOperations.bindParameters(this.extractNamedMutationQuery(entityClass, panacheQuery), params).executeUpdate();
        }
        try {
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createMutationQuery(PanacheJpaUtil.createDeleteQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params))), params).executeUpdate();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public long delete(Class<?> entityClass, String query, Parameters params) {
        return this.delete(entityClass, query, params.map());
    }

    public static IllegalStateException implementationInjectionMissing() {
        return new IllegalStateException("This method is normally automatically overridden in subclasses: did you forget to annotate your entity with @Entity?");
    }

    public int executeUpdate(String query, Object ... params) {
        return AbstractJpaOperations.bindParameters(this.getSession("<default>").createMutationQuery(query), params).executeUpdate();
    }

    public int executeUpdate(String query, Map<String, Object> params) {
        return AbstractJpaOperations.bindParameters(this.getSession("<default>").createMutationQuery(query), params).executeUpdate();
    }

    public int executeUpdate(Class<?> entityClass, String panacheQuery, Object ... params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return AbstractJpaOperations.bindParameters(this.extractNamedMutationQuery(entityClass, panacheQuery), params).executeUpdate();
        }
        try {
            String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createMutationQuery(updateQuery), params).executeUpdate();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public int executeUpdate(Class<?> entityClass, String panacheQuery, Map<String, Object> params) {
        if (PanacheJpaUtil.isNamedQuery((String)panacheQuery)) {
            return AbstractJpaOperations.bindParameters(this.extractNamedMutationQuery(entityClass, panacheQuery), params).executeUpdate();
        }
        try {
            String updateQuery = PanacheJpaUtil.createUpdateQuery(entityClass, (String)panacheQuery, (int)this.paramCount(params));
            return AbstractJpaOperations.bindParameters(this.getSession(entityClass).createMutationQuery(updateQuery), params).executeUpdate();
        }
        catch (RuntimeException x) {
            throw NamedQueryUtil.checkForNamedQueryMistake(x, panacheQuery);
        }
    }

    public int update(Class<?> entityClass, String query, Map<String, Object> params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public int update(Class<?> entityClass, String query, Parameters params) {
        return this.update(entityClass, query, params.map());
    }

    public int update(Class<?> entityClass, String query, Object ... params) {
        return this.executeUpdate(entityClass, query, params);
    }

    public static void setRollbackOnly() {
        try {
            AbstractJpaOperations.getTransactionManager().setRollbackOnly();
        }
        catch (SystemException e) {
            throw new IllegalStateException(e);
        }
    }
}

