/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.dev.ui;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.hibernate.orm.dev.HibernateOrmDevController;
import io.quarkus.hibernate.orm.dev.HibernateOrmDevInfo;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Transaction;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.SelectionQuery;
import org.hibernate.query.spi.SqmQuery;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.tool.language.internal.MetamodelJsonSerializerImpl;
import org.hibernate.tool.language.internal.ResultsJsonSerializerImpl;
import org.jboss.logging.Logger;

public class HibernateOrmDevJsonRpcService {
    private static final Logger LOG = Logger.getLogger(HibernateOrmDevJsonRpcService.class);
    private final boolean isDev = LaunchMode.current().isDev() && !LaunchMode.current().isRemoteDev();
    private final String allowedHost = ConfigProvider.getConfig().getOptionalValue("quarkus.datasource.dev-ui.allowed-db-host", String.class).orElse(null);
    @Inject
    Instance<Optional<Assistant>> assistant;
    private static final String SYSTEM_MESSAGE = "You are an expert in writing Hibernate Query Language (HQL) queries.\nYou have access to a entity model with the following structure:\n\n{{metamodel}}\n\nIf a user asks a question that can be answered by querying this model, generate an HQL SELECT query.\nThe query must not include any input parameters.\nYour response must only contain one field called `hql` containing the HQL query, nothing else, no explanation, and do not put the query in backticks.\nExample response: {\"hql\": \"select e from Entity e where e.property = :value\"}\n";
    private static final String INTERACTIVE_PROMPT = "The following HQL query:\n{{query}}\nreturned the following data (in JSON format):\n{{data}}\n\nBased on the data above, answer this request in natural language:\n{{user_request}}\nYour response must only contain one field called `answer` containing the natural language response.\nDo not include any HQL query in your response, nor suggest any further steps to take.\nExample response: {\"answer\": \"...\"}\n";

    public HibernateOrmDevInfo getInfo() {
        return HibernateOrmDevController.get().getInfo();
    }

    public int getNumberOfPersistenceUnits() {
        return this.getInfo().getPersistenceUnits().size();
    }

    public int getNumberOfEntityTypes() {
        return this.getInfo().getNumberOfEntities();
    }

    public int getNumberOfNamedQueries() {
        return this.getInfo().getNumberOfNamedQueries();
    }

    private Optional<HibernateOrmDevInfo.PersistenceUnit> findPersistenceUnit(String persistenceUnitName) {
        return this.getInfo().getPersistenceUnits().stream().filter(pu -> pu.getName().equals(persistenceUnitName)).findFirst();
    }

    public CompletionStage<Map<String, String>> executeHQL(String persistenceUnit, String query, Integer pageNumber, Integer pageSize, Boolean assistant, Boolean interactive) {
        if (!this.isDev) {
            return HibernateOrmDevJsonRpcService.errorDataSet("This method is only allowed in dev mode");
        }
        if (!this.hqlIsValid(query)) {
            return HibernateOrmDevJsonRpcService.errorDataSet("The provided HQL was not valid");
        }
        Optional<HibernateOrmDevInfo.PersistenceUnit> pu = this.findPersistenceUnit(persistenceUnit);
        if (pu.isEmpty()) {
            return HibernateOrmDevJsonRpcService.errorDataSet("No such persistence unit: " + persistenceUnit);
        }
        SessionFactoryImplementor sf = pu.get().sessionFactory();
        ConnectionProvider connectionProvider = (ConnectionProvider)sf.getServiceRegistry().requireService(ConnectionProvider.class);
        if (connectionProvider instanceof QuarkusConnectionProvider) {
            QuarkusConnectionProvider quarkusConnectionProvider = (QuarkusConnectionProvider)connectionProvider;
            if (!this.isAllowedDatabase(quarkusConnectionProvider.getDataSource())) {
                return HibernateOrmDevJsonRpcService.errorDataSet("The persistence unit's datasource points to a non-allowed datasource. By default only local databases are enabled; you can use the 'quarkus.datasource.dev-ui.allowed-db-host' configuration property to configure allowed hosts ('*' to allow all).");
            }
        } else {
            return HibernateOrmDevJsonRpcService.errorDataSet("Unsupported Connection Provider type for specified persistence unit.");
        }
        if (Boolean.TRUE.equals(assistant)) {
            if (!this.assistant.isResolvable()) {
                return HibernateOrmDevJsonRpcService.errorDataSet("The assistant is not available, please install the Chappie extension.");
            }
            Assistant a = ((Optional)this.assistant.get()).orElse(null);
            if (a == null || !a.isAvailable()) {
                return HibernateOrmDevJsonRpcService.errorDataSet("The assistant is not available, please check the Quarkus assistant extension is correctly configured.");
            }
            String metamodel = MetamodelJsonSerializerImpl.INSTANCE.toString(sf.getMetamodel());
            CompletionStage queryCompletionStage = a.assistBuilder().systemMessage(SYSTEM_MESSAGE).userMessage(query).addVariable("metamodel", metamodel).assist();
            CompletionStage<DataSet> dataSetCompletionStage = queryCompletionStage.thenApply(response -> {
                String hql = (String)response.get("hql");
                if (hql == null || hql.isBlank()) {
                    return new DataSet(null, null, -1L, null, "The assistant did not return a valid HQL query.");
                }
                return HibernateOrmDevJsonRpcService.executeHqlQuery(hql, sf, null, null);
            });
            if (Boolean.TRUE.equals(interactive)) {
                return dataSetCompletionStage.thenCompose(dataSet -> {
                    if (dataSet.error() != null) {
                        return CompletableFuture.completedStage(HibernateOrmDevJsonRpcService.toMap(dataSet));
                    }
                    CompletionStage interactiveCompletionStage = a.assistBuilder().systemMessage(SYSTEM_MESSAGE).addVariable("metamodel", metamodel).userMessage(INTERACTIVE_PROMPT).addVariable("query", dataSet.query()).addVariable("data", dataSet.data()).addVariable("user_request", query).assist();
                    return interactiveCompletionStage.thenApply(response -> {
                        String answer = (String)response.get("answer");
                        return HibernateOrmDevJsonRpcService.messageDataset(dataSet.query(), answer, dataSet.resultCount());
                    });
                });
            }
            return dataSetCompletionStage.thenApply(HibernateOrmDevJsonRpcService::toMap);
        }
        DataSet result = HibernateOrmDevJsonRpcService.executeHqlQuery(query, sf, pageNumber, pageSize);
        return CompletableFuture.completedStage(HibernateOrmDevJsonRpcService.toMap(result));
    }

    private static DataSet executeHqlQuery(String hql, SessionFactoryImplementor sf, Integer pageNumber, Integer pageSize) {
        return (DataSet)sf.fromSession(session -> {
            Transaction transaction = session.beginTransaction();
            try {
                ArrayList<Object> results;
                long resultCount;
                Query query = session.createQuery(hql, null);
                if (SqmUtil.isMutation((SqmStatement)((SqmQuery)query).getSqmStatement())) {
                    int updateCount = query.executeUpdate();
                    transaction.commit();
                    return new DataSet(null, hql, -1L, "Query executed correctly. Rows affected: " + updateCount, null);
                }
                if (pageNumber != null && pageSize != null) {
                    resultCount = query.getResultCount();
                    try (ScrollableResults scroll = query.scroll(ScrollMode.SCROLL_INSENSITIVE);){
                        boolean hasNext = scroll.scroll((pageNumber - 1) * pageSize + 1);
                        results = new ArrayList<Object>(pageSize);
                        int i = 0;
                        while (hasNext && i++ < pageSize) {
                            results.add(scroll.get());
                            hasNext = scroll.next();
                        }
                    }
                } else {
                    results = query.getResultList();
                    resultCount = results.size();
                }
                ResultsJsonSerializerImpl serializer = new ResultsJsonSerializerImpl(sf);
                String json = serializer.toString((List)results, (SelectionQuery)query);
                DataSet ds = new DataSet(json, hql, resultCount, null, null);
                transaction.commit();
                return ds;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error executing HQL query", (Throwable)ex);
                transaction.rollback();
                return new DataSet(null, null, -1L, null, ex.getMessage());
            }
        });
    }

    private static CompletionStage<Map<String, String>> errorDataSet(String errorMessage) {
        return CompletableFuture.completedStage(HibernateOrmDevJsonRpcService.toMap(new DataSet(null, null, -1L, null, errorMessage)));
    }

    private static Map<String, String> messageDataset(String query, String message, long resultCount) {
        return HibernateOrmDevJsonRpcService.toMap(new DataSet(null, query, resultCount, message, null));
    }

    private static Map<String, String> toMap(DataSet dataSet) {
        StringBuilder jsonBuilder = new StringBuilder("{");
        jsonBuilder.append("\"resultCount\":").append(dataSet.resultCount());
        if (dataSet.data() != null) {
            jsonBuilder.append(",\"data\":").append(dataSet.data());
        }
        HibernateOrmDevJsonRpcService.appendIfNonNull(jsonBuilder, "query", dataSet.query());
        HibernateOrmDevJsonRpcService.appendIfNonNull(jsonBuilder, "message", dataSet.message());
        HibernateOrmDevJsonRpcService.appendIfNonNull(jsonBuilder, "error", dataSet.error());
        jsonBuilder.append("}");
        Map<String, String> map = Map.of("response", jsonBuilder.toString(), "messageType", "Response", "alreadySerialized", "true");
        return map;
    }

    private static void appendIfNonNull(StringBuilder sb, String fieldName, String value) {
        if (value != null) {
            sb.append(",\"").append(fieldName).append("\":\"").append(value).append("\"");
        }
    }

    private boolean hqlIsValid(String hql) {
        return hql != null && !hql.trim().isEmpty();
    }

    private boolean isAllowedDatabase(AgroalDataSource ads) {
        String allowedHost;
        String string = allowedHost = this.allowedHost == null ? null : this.allowedHost.trim();
        if (allowedHost != null && allowedHost.equals("*")) {
            return true;
        }
        AgroalDataSourceConfiguration configuration = ads.getConfiguration();
        String jdbcUrl = configuration.connectionPoolConfiguration().connectionFactoryConfiguration().jdbcUrl();
        try {
            if (jdbcUrl.startsWith("jdbc:h2:mem:") || jdbcUrl.startsWith("jdbc:h2:file:") || jdbcUrl.startsWith("jdbc:h2:tcp://localhost") || allowedHost != null && !allowedHost.isBlank() && jdbcUrl.startsWith("jdbc:h2:tcp://" + allowedHost) || jdbcUrl.startsWith("jdbc:derby:memory:")) {
                return true;
            }
            String cleanUrl = jdbcUrl.replace("jdbc:", "");
            URI uri = new URI(cleanUrl);
            String host = uri.getHost();
            return host != null && (host.equals("localhost") || host.equals("127.0.0.1") || host.equals("::1") || allowedHost != null && !allowedHost.isBlank() && host.equalsIgnoreCase(allowedHost));
        }
        catch (URISyntaxException e) {
            LOG.warn((Object)e.getMessage());
            return false;
        }
    }

    public record DataSet(String data, String query, long resultCount, String message, String error) {
    }
}

