/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.config;

import io.quarkus.grpc.runtime.config.Enabled;
import io.quarkus.grpc.runtime.config.InProcess;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import io.vertx.core.http.ClientAuth;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

@ConfigGroup
public interface GrpcServerConfiguration {
    @WithDefault(value="true")
    public boolean useSeparateServer();

    @ConfigDocSection(generated=true)
    public Xds xds();

    public InProcess inProcess();

    @WithDefault(value="9000")
    public int port();

    @WithDefault(value="9001")
    public int testPort();

    @WithDefault(value="0.0.0.0")
    public String host();

    public Optional<Duration> handshakeTimeout();

    public OptionalInt maxInboundMessageSize();

    public OptionalInt maxInboundMetadataSize();

    public SslServerConfig ssl();

    @WithDefault(value="true")
    public boolean plainText();

    default public boolean isPlainTextEnabled() {
        boolean plainText = this.plainText();
        if (plainText && (this.ssl().certificate().isPresent() || this.ssl().keyStore().isPresent())) {
            plainText = false;
        }
        return plainText;
    }

    @WithDefault(value="true")
    public boolean alpn();

    public GrpcTransportSecurity transportSecurity();

    @WithDefault(value="false")
    public boolean enableReflectionService();

    @WithDefault(value="1")
    public int instances();

    public GrpcServerNettyConfig netty();

    public Optional<String> compression();

    @ConfigGroup
    public static interface SslServerConfig {
        public Optional<Path> certificate();

        public Optional<Path> key();

        public Optional<Path> keyStore();

        public Optional<String> keyStoreType();

        public Optional<String> keyStorePassword();

        public Optional<String> keyStoreAlias();

        public Optional<String> keyStoreAliasPassword();

        public Optional<Path> trustStore();

        public Optional<String> trustStoreType();

        public Optional<String> trustStorePassword();

        public Optional<List<String>> cipherSuites();

        @WithDefault(value="TLSv1.3,TLSv1.2")
        public Set<String> protocols();

        @WithDefault(value="NONE")
        public ClientAuth clientAuth();
    }

    @ConfigGroup
    public static interface Xds
    extends Enabled {
        @Override
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="false")
        public boolean secure();
    }

    @ConfigGroup
    public static interface GrpcTransportSecurity {
        public Optional<String> certificate();

        public Optional<String> key();
    }

    @ConfigGroup
    public static interface GrpcServerNettyConfig {
        public Optional<Duration> keepAliveTime();

        public Optional<Duration> permitKeepAliveTime();

        public Optional<Boolean> permitKeepAliveWithoutCalls();
    }
}

