/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.auth;

import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import io.grpc.StatusException;
import io.quarkus.grpc.auth.AuthExceptionHandler;
import io.quarkus.grpc.auth.AuthExceptionHandlerProvider;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.security.AuthenticationException;
import jakarta.inject.Singleton;

@Singleton
public class DefaultAuthExceptionHandlerProvider
implements AuthExceptionHandlerProvider {
    private final boolean addStatusDescription = LaunchMode.current().isDevOrTest();

    public int getPriority() {
        return 0;
    }

    @Override
    public <ReqT, RespT> AuthExceptionHandler<ReqT, RespT> createHandler(ServerCall.Listener<ReqT> listener, ServerCall<ReqT, RespT> serverCall, Metadata metadata) {
        return new AuthExceptionHandler<ReqT, RespT>(listener, serverCall, metadata, this.addStatusDescription);
    }

    @Override
    public StatusException transformToStatusException(Throwable t) {
        return new StatusException(DefaultAuthExceptionHandlerProvider.transformToStatusException(this.addStatusDescription, t));
    }

    @Override
    public boolean handlesException(Throwable failure) {
        return failure instanceof AuthenticationException || failure instanceof SecurityException;
    }

    static Status transformToStatusException(boolean addExceptionMessage, Throwable exception) {
        if (exception instanceof AuthenticationException) {
            if (addExceptionMessage) {
                return Status.UNAUTHENTICATED.withDescription(exception.getMessage());
            }
            return Status.UNAUTHENTICATED;
        }
        if (exception instanceof SecurityException) {
            if (addExceptionMessage) {
                return Status.PERMISSION_DENIED.withDescription(exception.getMessage());
            }
            return Status.PERMISSION_DENIED;
        }
        throw new IllegalStateException("Cannot transform exception " + String.valueOf(exception), exception);
    }
}

