/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InstanceHandle;
import jakarta.enterprise.inject.AmbiguousResolutionException;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface InjectableInstance<T>
extends Instance<T> {
    @Override
    public InstanceHandle<T> getHandle();

    @Override
    public Iterable<InstanceHandle<T>> handles();

    @Override
    default public Stream<InstanceHandle<T>> handlesStream() {
        return StreamSupport.stream(this.handles().spliterator(), false);
    }

    @Override
    public InjectableInstance<T> select(Annotation ... var1);

    @Override
    public <U extends T> InjectableInstance<U> select(Class<U> var1, Annotation ... var2);

    @Override
    public <U extends T> InjectableInstance<U> select(TypeLiteral<U> var1, Annotation ... var2);

    public void clearCache();

    @Override
    public Iterator<T> iterator();

    default public T orElse(T other) {
        return this.isResolvable() ? this.get() : other;
    }

    default public T orNull() {
        return this.orElse(null);
    }

    default public T getActive() {
        List<T> list = this.listActive();
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.isEmpty()) {
            throw new UnsatisfiedResolutionException("No active bean found");
        }
        throw new AmbiguousResolutionException("More than one active bean found: " + String.valueOf(list));
    }

    default public List<T> listActive() {
        return this.handlesStream().filter(it -> it.getBean().isActive()).map(InstanceHandle::get).toList();
    }
}

