/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;

public class ConditionalDependenciesEnabler {
    private final Map<ArtifactKey, Set<ExtensionDependency<?>>> featureVariants = new HashMap();
    private final Map<ModuleVersionIdentifier, ExtensionDependency<?>> allExtensions = new HashMap();
    private final Project project;
    private final Configuration enforcedPlatforms;
    private final Set<ArtifactKey> existingArtifacts = new HashSet<ArtifactKey>();
    private final List<Dependency> unsatisfiedConditionalDeps = new ArrayList<Dependency>();

    public ConditionalDependenciesEnabler(Project project, LaunchMode mode, Configuration platforms) {
        this.project = project;
        this.enforcedPlatforms = platforms;
        Configuration baseRuntimeConfig = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(mode));
        if (!baseRuntimeConfig.getIncoming().getDependencies().isEmpty()) {
            this.collectConditionalDependencies(baseRuntimeConfig.getResolvedConfiguration().getResolvedArtifacts(), mode);
            while (!this.unsatisfiedConditionalDeps.isEmpty()) {
                boolean satisfiedConditionalDeps = false;
                int originalUnsatisfiedCount = this.unsatisfiedConditionalDeps.size();
                int i = 0;
                while (i < this.unsatisfiedConditionalDeps.size()) {
                    Dependency conditionalDep = this.unsatisfiedConditionalDeps.get(i);
                    if (this.resolveConditionalDependency(conditionalDep, mode)) {
                        satisfiedConditionalDeps = true;
                        this.unsatisfiedConditionalDeps.remove(i);
                        continue;
                    }
                    ++i;
                }
                if (satisfiedConditionalDeps || this.unsatisfiedConditionalDeps.size() != originalUnsatisfiedCount) continue;
                break;
            }
            this.reset();
        }
    }

    public Collection<ExtensionDependency<?>> getAllExtensions() {
        return this.allExtensions.values();
    }

    private void reset() {
        this.featureVariants.clear();
        this.existingArtifacts.clear();
        this.unsatisfiedConditionalDeps.clear();
    }

    private void collectConditionalDependencies(Set<ResolvedArtifact> runtimeArtifacts, LaunchMode mode) {
        for (ResolvedArtifact artifact : runtimeArtifacts) {
            this.existingArtifacts.add(ConditionalDependenciesEnabler.getKey(artifact));
            ExtensionDependency<?> extension = DependencyUtils.getExtensionInfoOrNull(this.project, artifact);
            if (extension == null) continue;
            this.allExtensions.put(extension.getExtensionId(), extension);
            this.queueConditionalDependencies(extension, mode);
        }
    }

    private void queueConditionalDependencies(ExtensionDependency<?> extension, LaunchMode mode) {
        this.queueConditionalDependencies(extension, extension.getConditionalDependencies());
        if (LaunchMode.DEVELOPMENT.equals((Object)mode)) {
            this.queueConditionalDependencies(extension, extension.getConditionalDevDependencies());
        }
    }

    private void queueConditionalDependencies(ExtensionDependency<?> extension, Collection<Dependency> conditionalDeps) {
        for (Dependency conditionalDep : conditionalDeps) {
            if (this.exists(conditionalDep)) continue;
            this.queueConditionalDependency(extension, conditionalDep);
        }
    }

    private boolean resolveConditionalDependency(Dependency conditionalDep, LaunchMode mode) {
        ExtensionDependency<?> extensionDependency;
        Configuration conditionalDeps = this.createConditionalDependenciesConfiguration(this.project, conditionalDep);
        Set resolvedArtifacts = conditionalDeps.getResolvedConfiguration().getResolvedArtifacts();
        boolean satisfied = false;
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            if (!conditionalDep.getName().equals(artifact.getName()) || !conditionalDep.getVersion().equals(artifact.getModuleVersion().getId().getVersion()) || !artifact.getModuleVersion().getId().getGroup().equals(conditionalDep.getGroup()) || (extensionDependency = DependencyUtils.getExtensionInfoOrNull(this.project, artifact)) != null && !extensionDependency.getDependencyConditions().isEmpty() && !this.exist(extensionDependency.getDependencyConditions())) continue;
            satisfied = true;
            this.enableConditionalDependency(artifact.getModuleVersion().getId());
            break;
        }
        if (!satisfied) {
            return false;
        }
        for (ResolvedArtifact artifact : resolvedArtifacts) {
            this.existingArtifacts.add(ConditionalDependenciesEnabler.getKey(artifact));
            extensionDependency = DependencyUtils.getExtensionInfoOrNull(this.project, artifact);
            if (extensionDependency == null) continue;
            extensionDependency.setConditional(true);
            this.allExtensions.put(extensionDependency.getExtensionId(), extensionDependency);
            this.queueConditionalDependencies(extensionDependency, mode);
        }
        return satisfied;
    }

    private void queueConditionalDependency(ExtensionDependency<?> extension, Dependency conditionalDep) {
        this.featureVariants.computeIfAbsent(ConditionalDependenciesEnabler.getFeatureKey(conditionalDep), k -> {
            this.unsatisfiedConditionalDeps.add(conditionalDep);
            return new HashSet();
        }).add(extension);
    }

    private Configuration createConditionalDependenciesConfiguration(Project project, Dependency conditionalDep) {
        Configuration conditionalDepConfiguration = project.getConfigurations().detachedConfiguration(new Dependency[0]).extendsFrom(new Configuration[]{this.enforcedPlatforms});
        conditionalDepConfiguration.getDependencies().add((Object)conditionalDep);
        return conditionalDepConfiguration;
    }

    private void enableConditionalDependency(ModuleVersionIdentifier dependency) {
        Set<ExtensionDependency<?>> extensions = this.featureVariants.remove(ConditionalDependenciesEnabler.getFeatureKey(dependency));
        if (extensions == null) {
            return;
        }
        extensions.forEach(e -> e.importConditionalDependency(this.project.getDependencies(), dependency));
    }

    private boolean exist(List<ArtifactKey> dependencies) {
        return this.existingArtifacts.containsAll(dependencies);
    }

    private boolean exists(Dependency dependency) {
        return this.existingArtifacts.contains(ArtifactKey.of((String)dependency.getGroup(), (String)dependency.getName(), null, (String)"jar"));
    }

    public boolean exists(ExtensionDependency<?> dependency) {
        return this.existingArtifacts.contains(ArtifactKey.of((String)dependency.getGroup(), (String)dependency.getName(), null, (String)"jar"));
    }

    private static ArtifactKey getFeatureKey(ModuleVersionIdentifier version) {
        return ArtifactKey.ga((String)version.getGroup(), (String)version.getName());
    }

    private static ArtifactKey getFeatureKey(Dependency version) {
        return ArtifactKey.ga((String)version.getGroup(), (String)version.getName());
    }

    private static ArtifactKey getKey(ResolvedArtifact a) {
        return ArtifactKey.of((String)a.getModuleVersion().getId().getGroup(), (String)a.getName(), (String)a.getClassifier(), (String)a.getType());
    }
}

