/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gcp.functions.http.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

public class CloudFunctionsDeploymentBuildStep {
    @BuildStep(onlyIf={IsNormal.class}, onlyIfNot={NativeBuild.class})
    public ArtifactResultBuildItem functionDeployment(OutputTargetBuildItem target, JarBuildItem jar) throws BuildException, IOException {
        if (!jar.isUberJar()) {
            throw new BuildException("Google Cloud Function deployment need to use a uberjar, please set 'quarkus.package.jar.type=uber-jar' inside your application.properties", List.of());
        }
        Path deployment = target.getOutputDirectory().resolve("deployment");
        if (Files.notExists(deployment, new LinkOption[0])) {
            Files.createDirectory(deployment, new FileAttribute[0]);
        }
        Path jarPath = jar.getPath();
        Path targetJarPath = deployment.resolve(jarPath.getFileName());
        Files.deleteIfExists(targetJarPath);
        Files.copy(jarPath, targetJarPath, new CopyOption[0]);
        return new ArtifactResultBuildItem(targetJarPath, "function", Map.of());
    }
}

