/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.lambda.event.sqs;

import com.amazonaws.services.lambda.runtime.events.SQSBatchResponse;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import io.quarkus.funqy.lambda.config.FunqyAmazonConfig;
import io.quarkus.funqy.lambda.event.EventHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class SqsEventHandler
implements EventHandler<SQSEvent, SQSEvent.SQSMessage, SQSBatchResponse> {
    @Override
    public Stream<SQSEvent.SQSMessage> streamEvent(SQSEvent event, FunqyAmazonConfig amazonConfig) {
        if (event == null) {
            return Stream.empty();
        }
        return event.getRecords().stream();
    }

    @Override
    public String getIdentifier(SQSEvent.SQSMessage message, FunqyAmazonConfig amazonConfig) {
        return message.getMessageId();
    }

    @Override
    public Supplier<InputStream> getBody(SQSEvent.SQSMessage message, FunqyAmazonConfig amazonConfig) {
        if (message.getBody() == null) {
            return InputStream::nullInputStream;
        }
        return () -> new ByteArrayInputStream(message.getBody().getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public SQSBatchResponse createResponse(List<String> failures, FunqyAmazonConfig amazonConfig) {
        if (!amazonConfig.advancedEventHandling().sqs().reportBatchItemFailures()) {
            return null;
        }
        return SQSBatchResponse.builder().withBatchItemFailures(failures.stream().map(id -> SQSBatchResponse.BatchItemFailure.builder().withItemIdentifier(id).build()).toList()).build();
    }

    @Override
    public Class<SQSEvent.SQSMessage> getMessageClass() {
        return SQSEvent.SQSMessage.class;
    }
}

