/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.quarkus.arc.All;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.flyway.FlywayConfigurationCustomizer;
import io.quarkus.flyway.FlywayDataSource;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayCreator;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceRuntimeConfig;
import io.quarkus.flyway.runtime.FlywayRuntimeConfig;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.callback.Callback;

public class FlywayContainerProducer {
    private final FlywayRuntimeConfig flywayRuntimeConfig;
    private final FlywayBuildTimeConfig flywayBuildConfig;
    private final List<InstanceHandle<FlywayConfigurationCustomizer>> configCustomizerInstances;

    public FlywayContainerProducer(FlywayRuntimeConfig flywayRuntimeConfig, FlywayBuildTimeConfig flywayBuildConfig, @All List<InstanceHandle<FlywayConfigurationCustomizer>> configCustomizerInstances) {
        this.flywayRuntimeConfig = flywayRuntimeConfig;
        this.flywayBuildConfig = flywayBuildConfig;
        this.configCustomizerInstances = configCustomizerInstances;
    }

    public FlywayContainer createFlyway(DataSource dataSource, String dataSourceName, boolean hasMigrations, boolean createPossible) {
        FlywayDataSourceRuntimeConfig matchingRuntimeConfig = this.flywayRuntimeConfig.getConfigForDataSourceName(dataSourceName);
        FlywayDataSourceBuildTimeConfig matchingBuildTimeConfig = this.flywayBuildConfig.getConfigForDataSourceName(dataSourceName);
        Collection<Callback> callbacks = QuarkusPathLocationScanner.callbacksForDataSource(dataSourceName);
        Flyway flyway = new FlywayCreator(matchingRuntimeConfig, matchingBuildTimeConfig, this.matchingConfigCustomizers(this.configCustomizerInstances, dataSourceName)).withCallbacks(callbacks).createFlyway(dataSource);
        return new FlywayContainer(flyway, matchingRuntimeConfig.baselineAtStart, matchingRuntimeConfig.cleanAtStart, matchingRuntimeConfig.migrateAtStart, matchingRuntimeConfig.repairAtStart, matchingRuntimeConfig.validateAtStart, dataSourceName, hasMigrations, createPossible);
    }

    private List<FlywayConfigurationCustomizer> matchingConfigCustomizers(List<InstanceHandle<FlywayConfigurationCustomizer>> configCustomizerInstances, String dataSourceName) {
        if (configCustomizerInstances == null || configCustomizerInstances.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FlywayConfigurationCustomizer> result = new ArrayList<FlywayConfigurationCustomizer>();
        for (InstanceHandle<FlywayConfigurationCustomizer> instance : configCustomizerInstances) {
            Set qualifiers = instance.getBean().getQualifiers();
            boolean qualifierMatchesDS = false;
            boolean hasFlywayDataSourceQualifier = false;
            for (Annotation qualifier : qualifiers) {
                if (!qualifier.annotationType().equals(FlywayDataSource.class)) continue;
                hasFlywayDataSourceQualifier = true;
                if (!dataSourceName.equals(((FlywayDataSource)qualifier).value())) continue;
                qualifierMatchesDS = true;
                break;
            }
            if (qualifierMatchesDS) {
                result.add((FlywayConfigurationCustomizer)instance.get());
                continue;
            }
            if (!DataSourceUtil.isDefault((String)dataSourceName) || hasFlywayDataSourceQualifier) continue;
            result.add((FlywayConfigurationCustomizer)instance.get());
        }
        return result;
    }
}

