/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.stream.Stream;

public class FsMap {
    private final Path dir;

    public FsMap(Path dir) {
        this.dir = FsMap.safeCreateDirectories(dir);
    }

    public String get(String key) {
        Path file = this.dir.resolve(key);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return Files.readString(file);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read " + String.valueOf(file), e);
            }
        }
        return null;
    }

    public void put(String key, String value) {
        Path file = this.dir.resolve(key);
        try {
            Files.write(file, value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write " + String.valueOf(file), e);
        }
    }

    public boolean hasKey(String key) {
        Path file = this.dir.resolve(key);
        return Files.exists(file, new LinkOption[0]);
    }

    static Path safeCreateDirectories(Path dir) {
        int retries = dir.getNameCount();
        while (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                return dir;
            }
            catch (IOException e) {
                IOException lastException = e;
                if (retries-- > 0) continue;
                throw new RuntimeException("Could not create directories " + String.valueOf(dir), lastException);
            }
            break;
        }
        return dir;
    }

    public Properties asProperties() {
        Properties result = new Properties();
        if (Files.exists(this.dir, new LinkOption[0])) {
            try (Stream<Path> files = Files.list(this.dir);){
                files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                    try {
                        result.setProperty(f.getFileName().toString(), Files.readString(f));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Could not read from " + String.valueOf(f), e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Could not list " + String.valueOf(this.dir), e);
            }
        }
        return result;
    }
}

