/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigMappingListener;
import io.quarkus.annotation.processor.documentation.config.scanner.JavadocConfigMappingListener;
import io.quarkus.annotation.processor.documentation.config.util.TypeUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class ConfigAnnotationScanner {
    private final Utils utils;
    private final Config config;
    private final ConfigCollector configCollector;
    private final Set<String> configGroupClassNames = new HashSet<String>();
    private final Set<String> configRootClassNames = new HashSet<String>();
    private final Set<String> configMappingWithoutConfigRootClassNames = new HashSet<String>();
    private final Set<String> enumClassNames = new HashSet<String>();
    private final List<ConfigAnnotationListener> configRootListeners;
    private final List<ConfigAnnotationListener> configMappingWithoutConfigRootListeners;

    public ConfigAnnotationScanner(Config config, Utils utils) {
        this.config = config;
        this.utils = utils;
        this.configCollector = new ConfigCollector();
        ArrayList<ConfigAnnotationListener> configRootListeners = new ArrayList<ConfigAnnotationListener>();
        ArrayList<JavadocConfigMappingListener> configMappingWithoutConfigRootListeners = new ArrayList<JavadocConfigMappingListener>();
        configRootListeners.add(new JavadocConfigMappingListener(config, utils, this.configCollector));
        configRootListeners.add(new ConfigMappingListener(config, utils, this.configCollector));
        configMappingWithoutConfigRootListeners.add(new JavadocConfigMappingListener(config, utils, this.configCollector));
        this.configRootListeners = Collections.unmodifiableList(configRootListeners);
        this.configMappingWithoutConfigRootListeners = Collections.unmodifiableList(configMappingWithoutConfigRootListeners);
    }

    public void scanConfigGroups(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement configGroup : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (this.isConfigGroupAlreadyHandled(configGroup)) continue;
            this.debug("Detected annotated config group: " + String.valueOf(configGroup), configGroup);
            try {
                DiscoveryConfigGroup discoveryConfigGroup = (DiscoveryConfigGroup)this.applyRootListeners(l -> l.onConfigGroup(configGroup));
                this.scanElement(this.configRootListeners, discoveryConfigGroup, configGroup);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to scan config group: " + String.valueOf(configGroup), e);
            }
        }
    }

    public void scanConfigRoots(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement configRoot : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            this.checkConfigRootAnnotationConsistency(configRoot);
            PackageElement pkg = this.utils.element().getPackageOf(configRoot);
            if (pkg == null) {
                this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + String.valueOf(configRoot) + " has no enclosing package");
                continue;
            }
            if (this.isConfigRootAlreadyHandled(configRoot)) continue;
            this.debug("Detected config root: " + String.valueOf(configRoot), configRoot);
            try {
                DiscoveryConfigRoot discoveryConfigRoot = (DiscoveryConfigRoot)this.applyRootListeners(l -> l.onConfigRoot(configRoot));
                this.scanElement(this.configRootListeners, discoveryConfigRoot, configRoot);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to scan config root: " + String.valueOf(configRoot), e);
            }
        }
    }

    public void scanConfigMappingsWithoutConfigRoot(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement configMappingWithoutConfigRoot : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (this.utils.element().isAnnotationPresent(configMappingWithoutConfigRoot, "io.quarkus.runtime.annotations.ConfigRoot")) continue;
            PackageElement pkg = this.utils.element().getPackageOf(configMappingWithoutConfigRoot);
            if (pkg == null) {
                this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + String.valueOf(configMappingWithoutConfigRoot) + " has no enclosing package");
                continue;
            }
            if (this.isConfigMappingWithoutConfigRootAlreadyHandled(configMappingWithoutConfigRoot)) continue;
            this.debug("Detected config mapping without config root: " + String.valueOf(configMappingWithoutConfigRoot), configMappingWithoutConfigRoot);
            try {
                DiscoveryConfigRoot discoveryConfigRoot = new DiscoveryConfigRoot(this.config.getExtension(), "dummy", "dummy", this.utils.element().getBinaryName(configMappingWithoutConfigRoot), configMappingWithoutConfigRoot.getQualifiedName().toString(), ConfigPhase.BUILD_TIME, null, true);
                this.scanElement(this.configMappingWithoutConfigRootListeners, discoveryConfigRoot, configMappingWithoutConfigRoot);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to scan config mapping without config root: " + String.valueOf(configMappingWithoutConfigRoot), e);
            }
        }
    }

    public ConfigCollector finalizeProcessing() {
        this.applyListeners(this.configRootListeners, l -> l.finalizeProcessing());
        this.applyListeners(this.configMappingWithoutConfigRootListeners, l -> l.finalizeProcessing());
        return this.configCollector;
    }

    private void scanElement(List<ConfigAnnotationListener> listeners, DiscoveryRootElement configRootElement, TypeElement clazz) {
        if (clazz.getKind() == ElementKind.INTERFACE) {
            List<? extends TypeMirror> superInterfaces = clazz.getInterfaces();
            for (TypeMirror typeMirror : superInterfaces) {
                TypeElement superInterfaceTypeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                this.debug("Detected superinterface: " + String.valueOf(superInterfaceTypeElement), clazz);
                this.applyListeners(listeners, l -> l.onInterface(configRootElement, superInterfaceTypeElement));
                this.scanElement(listeners, configRootElement, superInterfaceTypeElement);
            }
        } else {
            TypeMirror superclass = clazz.getSuperclass();
            if (superclass.getKind() != TypeKind.NONE && !this.utils.element().getQualifiedName(superclass).equals(Object.class.getName())) {
                TypeElement typeElement = (TypeElement)((DeclaredType)superclass).asElement();
                this.debug("Detected superclass: " + String.valueOf(typeElement), clazz);
                this.applyListeners(listeners, l -> l.onSuperclass(configRootElement, clazz));
                this.scanElement(listeners, configRootElement, typeElement);
            }
        }
        for (Element element : clazz.getEnclosedElements()) {
            switch (element.getKind()) {
                case INTERFACE: {
                    break;
                }
                case METHOD: {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    if (this.isMethodIgnored(executableElement)) break;
                    TypeMirror returnType = executableElement.getReturnType();
                    ResolvedType resolvedType = this.resolveType(returnType);
                    if (resolvedType.isEnum()) {
                        this.handleEnum(listeners, resolvedType.unwrappedTypeElement());
                    } else if (resolvedType.isInterface()) {
                        TypeElement unwrappedTypeElement = resolvedType.unwrappedTypeElement();
                        if (!this.utils.element().isJdkClass(unwrappedTypeElement) && !this.isConfigGroupAlreadyHandled(unwrappedTypeElement)) {
                            this.debug("Detected config group: " + String.valueOf(resolvedType) + " on method: " + String.valueOf(executableElement), clazz);
                            DiscoveryConfigGroup discoveryConfigGroup = (DiscoveryConfigGroup)this.applyRootListeners(l -> l.onConfigGroup(unwrappedTypeElement));
                            this.scanElement(listeners, discoveryConfigGroup, unwrappedTypeElement);
                        }
                    }
                    this.debug("Detected enclosed method: " + String.valueOf(executableElement), element);
                    this.applyListeners(listeners, l -> l.onEnclosedMethod(configRootElement, clazz, method, resolvedType));
                    break;
                }
                case FIELD: {
                    VariableElement variableElement = (VariableElement)element;
                    if (this.isFieldIgnored(variableElement)) break;
                    ResolvedType resolvedType = this.resolveType(variableElement.asType());
                    if (resolvedType.isEnum()) {
                        this.handleEnum(listeners, resolvedType.unwrappedTypeElement());
                    } else if (resolvedType.isClass()) {
                        TypeElement unwrappedTypeElement = resolvedType.unwrappedTypeElement();
                        if (this.utils.element().isAnnotationPresent(unwrappedTypeElement, "io.quarkus.runtime.annotations.ConfigGroup") && !this.isConfigGroupAlreadyHandled(unwrappedTypeElement)) {
                            this.debug("Detected config group: " + String.valueOf(resolvedType) + " on field: " + String.valueOf(variableElement), clazz);
                            DiscoveryConfigGroup discoveryConfigGroup = (DiscoveryConfigGroup)this.applyRootListeners(l -> l.onConfigGroup(unwrappedTypeElement));
                            this.scanElement(listeners, discoveryConfigGroup, unwrappedTypeElement);
                        }
                    }
                    this.debug("Detected enclosed field: " + String.valueOf(variableElement), clazz);
                    this.applyListeners(listeners, l -> l.onEnclosedField(configRootElement, clazz, field, resolvedType));
                    break;
                }
                case ENUM: {
                    this.handleEnum(listeners, (TypeElement)element);
                    break;
                }
            }
        }
    }

    private void handleEnum(List<ConfigAnnotationListener> listeners, TypeElement enumTypeElement) {
        if (this.isEnumAlreadyHandled(enumTypeElement)) {
            return;
        }
        this.applyListeners(listeners, l -> l.onResolvedEnum(enumTypeElement));
    }

    private boolean isConfigRootAlreadyHandled(TypeElement clazz) {
        String qualifiedName = clazz.getQualifiedName().toString();
        return !this.configRootClassNames.add(qualifiedName);
    }

    private boolean isConfigMappingWithoutConfigRootAlreadyHandled(TypeElement clazz) {
        String qualifiedName = clazz.getQualifiedName().toString();
        return !this.configMappingWithoutConfigRootClassNames.add(qualifiedName);
    }

    private boolean isConfigGroupAlreadyHandled(TypeElement clazz) {
        String qualifiedName = clazz.getQualifiedName().toString();
        return !this.configGroupClassNames.add(qualifiedName);
    }

    private boolean isEnumAlreadyHandled(TypeElement clazz) {
        String qualifiedName = clazz.getQualifiedName().toString();
        return !this.enumClassNames.add(qualifiedName);
    }

    private ResolvedType resolveType(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return ResolvedType.ofPrimitive(typeMirror, this.utils.element().getQualifiedName(typeMirror));
        }
        if (typeMirror.getKind() == TypeKind.ARRAY) {
            ResolvedType resolvedType = this.resolveType(((ArrayType)typeMirror).getComponentType());
            return ResolvedType.makeList(typeMirror, resolvedType);
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String qualifiedName = typeElement.getQualifiedName().toString();
        boolean optional = qualifiedName.startsWith(Optional.class.getName());
        boolean secret = qualifiedName.startsWith("io.smallrye.config.Secret");
        boolean map = qualifiedName.equals(Map.class.getName());
        boolean list = qualifiedName.equals(List.class.getName()) || qualifiedName.equals(Set.class.getName());
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            if (typeArguments.size() == 1 && optional) {
                return ResolvedType.makeOptional(this.resolveType(typeArguments.get(0)));
            }
            if (typeArguments.size() == 1 && secret) {
                return ResolvedType.makeSecret(this.resolveType(typeArguments.get(0)));
            }
            if (typeArguments.size() == 1 && list) {
                return ResolvedType.makeList(typeMirror, this.resolveType(typeArguments.get(0)));
            }
            if (typeArguments.size() == 2 && map) {
                return ResolvedType.makeMap(typeMirror, this.resolveType(typeArguments.get(1)));
            }
        }
        String binaryName = this.utils.element().getBinaryName(typeElement);
        String simplifiedName = this.getSimplifiedTypeName(typeElement);
        boolean isInterface = false;
        boolean isClass = false;
        boolean isEnum = false;
        boolean isDuration = false;
        boolean isConfigGroup = false;
        if (typeElement.getKind() == ElementKind.ENUM) {
            isEnum = true;
        } else if (typeElement.getKind() == ElementKind.INTERFACE) {
            isInterface = true;
            isConfigGroup = this.utils.element().isAnnotationPresent(typeElement, "io.quarkus.runtime.annotations.ConfigGroup");
        } else if (typeElement.getKind() == ElementKind.CLASS) {
            isClass = true;
            isDuration = this.utils.element().getQualifiedName(typeMirror).equals(Duration.class.getName());
            isConfigGroup = this.utils.element().isAnnotationPresent(typeElement, "io.quarkus.runtime.annotations.ConfigGroup");
        }
        ResolvedType resolvedType = ResolvedType.ofDeclaredType(typeMirror, binaryName, qualifiedName, simplifiedName, isInterface, isClass, isEnum, isDuration, isConfigGroup);
        if (optional) {
            return ResolvedType.makeOptional(resolvedType);
        }
        return resolvedType;
    }

    private String getSimplifiedTypeName(TypeElement typeElement) {
        String qualifiedName = typeElement.getQualifiedName().toString();
        String typeAlias = TypeUtil.getAlias(qualifiedName);
        if (typeAlias != null) {
            return typeAlias;
        }
        if (TypeUtil.isPrimitiveWrapper(qualifiedName)) {
            return TypeUtil.unbox(qualifiedName);
        }
        return typeElement.getSimpleName().toString();
    }

    public boolean isMethodIgnored(ExecutableElement method) {
        if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            return true;
        }
        if (method.getSimpleName().contentEquals("toString") && method.getParameters().isEmpty()) {
            return true;
        }
        return this.utils.element().isAnnotationPresent(method, "io.quarkus.runtime.annotations.ConfigDocIgnore");
    }

    public boolean isFieldIgnored(VariableElement field) {
        if (field.getModifiers().contains((Object)Modifier.STATIC)) {
            return true;
        }
        Map<String, AnnotationMirror> annotations = this.utils.element().getAnnotations(field);
        if (annotations.containsKey("io.quarkus.runtime.annotations.ConfigItem")) {
            Map<String, Object> annotationValues = this.utils.element().getAnnotationValues(annotations.get("io.quarkus.runtime.annotations.ConfigItem"));
            Boolean generateDocumentation = (Boolean)annotationValues.get("generateDocumentation");
            return generateDocumentation != null && generateDocumentation == false;
        }
        if (annotations.containsKey("io.quarkus.runtime.annotations.ConfigDocIgnore")) {
            return true;
        }
        if (annotations.containsKey("io.quarkus.runtime.annotations.ConfigDocSection")) {
            return false;
        }
        return false;
    }

    private void applyListeners(List<ConfigAnnotationListener> listeners, Consumer<ConfigAnnotationListener> listenerFunction) {
        for (ConfigAnnotationListener listener : listeners) {
            listenerFunction.accept(listener);
        }
    }

    private <T extends DiscoveryRootElement> T applyRootListeners(Function<ConfigAnnotationListener, Optional<T>> listenerFunction) {
        DiscoveryRootElement discoveryRootElement = null;
        for (ConfigAnnotationListener listener : this.configRootListeners) {
            Optional<T> discoveryRootElementCandidate = listenerFunction.apply(listener);
            if (!discoveryRootElementCandidate.isPresent()) continue;
            if (discoveryRootElement != null) {
                throw new IllegalStateException("Multiple listeners returned discovery root elements for: " + discoveryRootElement.getQualifiedName());
            }
            discoveryRootElement = (DiscoveryRootElement)discoveryRootElementCandidate.get();
        }
        if (discoveryRootElement == null) {
            throw new IllegalStateException("No listeners returned a discovery root element");
        }
        return (T)discoveryRootElement;
    }

    private void checkConfigRootAnnotationConsistency(TypeElement configRoot) {
        if (!this.utils.element().isAnnotationPresent(configRoot, "io.smallrye.config.ConfigMapping")) {
            throw new IllegalStateException("We found a @ConfigRoot without a corresponding @ConfigMapping annotation in: " + String.valueOf(configRoot) + ". Make sure your configuration interfaces are annotated with @ConfigMapping.");
        }
    }

    private void debug(String debug, Element element) {
        if (!this.config.isDebug()) {
            return;
        }
        this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.NOTE, "[" + String.valueOf(element.getSimpleName()) + "] " + debug);
    }
}

