/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import java.util.List;

public interface ConfigItemCollection {
    public List<AbstractConfigItem> getItems();

    @JsonIgnore
    default public List<ConfigProperty> getProperties() {
        return this.getItems().stream().filter(i -> i instanceof ConfigProperty).map(ConfigProperty.class::cast).toList();
    }

    @JsonIgnore
    default public List<ConfigSection> getSections() {
        return this.getItems().stream().filter(i -> i instanceof ConfigSection).map(ConfigSection.class::cast).toList();
    }

    @JsonIgnore
    default public List<AbstractConfigItem> getNonDeprecatedItems() {
        return this.getItems().stream().filter(i -> i instanceof ConfigSection ? !i.isDeprecated() && !((ConfigSection)i).getNonDeprecatedItems().isEmpty() : !i.isDeprecated()).toList();
    }

    @JsonIgnore
    default public List<ConfigProperty> getNonDeprecatedProperties() {
        return this.getItems().stream().filter(i -> i instanceof ConfigProperty && !i.isDeprecated()).map(ConfigProperty.class::cast).toList();
    }

    @JsonIgnore
    default public List<ConfigSection> getNonDeprecatedSections() {
        return this.getItems().stream().filter(i -> i instanceof ConfigSection && !i.isDeprecated()).map(ConfigSection.class::cast).toList();
    }

    public void addItem(AbstractConfigItem var1);

    public boolean hasDurationType();

    public boolean hasMemorySizeType();
}

