/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.resolver;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.EnumDefinition;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.AbstractConfigItem;
import io.quarkus.annotation.processor.documentation.config.model.ConfigItemCollection;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.ConfigProperty;
import io.quarkus.annotation.processor.documentation.config.model.ConfigRoot;
import io.quarkus.annotation.processor.documentation.config.model.ConfigSection;
import io.quarkus.annotation.processor.documentation.config.model.Deprecation;
import io.quarkus.annotation.processor.documentation.config.model.EnumAcceptedValues;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.model.ResolvedModel;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import io.quarkus.annotation.processor.documentation.config.util.JavadocUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Strings;
import io.quarkus.annotation.processor.util.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class ConfigResolver {
    private final Config config;
    private final Utils utils;
    private final ConfigCollector configCollector;

    public ConfigResolver(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    public JavadocElements resolveJavadoc() {
        return new JavadocElements(this.config.getExtension(), this.configCollector.getJavadocElements());
    }

    public ResolvedModel resolveModel() {
        ArrayList<ConfigRoot> configRoots = new ArrayList<ConfigRoot>();
        for (DiscoveryConfigRoot discoveryConfigRoot : this.configCollector.getConfigRoots()) {
            ConfigRoot configRoot = new ConfigRoot(discoveryConfigRoot.getExtension(), discoveryConfigRoot.getPrefix(), discoveryConfigRoot.getOverriddenDocPrefix(), discoveryConfigRoot.getOverriddenDocFileName());
            TreeMap<String, ConfigSection> existingRootConfigSections = new TreeMap<String, ConfigSection>();
            configRoot.addQualifiedName(discoveryConfigRoot.getQualifiedName());
            ResolutionContext context = new ResolutionContext(configRoot.getPrefix(), new ArrayList<String>(), discoveryConfigRoot, configRoot, 0, false, false, null);
            for (DiscoveryConfigProperty discoveryConfigProperty : discoveryConfigRoot.getProperties().values()) {
                this.resolveProperty(configRoot, existingRootConfigSections, discoveryConfigRoot.getPhase(), context, discoveryConfigProperty);
            }
            configRoots.add(configRoot);
        }
        return new ResolvedModel(configRoots);
    }

    private void resolveProperty(ConfigRoot configRoot, Map<String, ConfigSection> existingRootConfigSections, ConfigPhase phase, ResolutionContext context, DiscoveryConfigProperty discoveryConfigProperty) {
        String path = ConfigResolver.appendPath(context.getPath(), discoveryConfigProperty.getPath());
        List additionalPaths = context.getAdditionalPaths().stream().map(p -> ConfigResolver.appendPath(p, discoveryConfigProperty.getPath())).collect(Collectors.toCollection(ArrayList::new));
        Deprecation deprecation = discoveryConfigProperty.getDeprecation() != null ? discoveryConfigProperty.getDeprecation() : context.getDeprecation();
        String typeQualifiedName = discoveryConfigProperty.getType().qualifiedName();
        if (this.configCollector.isResolvedConfigGroup(typeQualifiedName)) {
            ResolutionContext configGroupContext;
            boolean isWithMapWithUnnamedKey;
            DiscoveryConfigGroup discoveryConfigGroup = this.configCollector.getResolvedConfigGroup(typeQualifiedName);
            Object potentiallyMappedPath = path;
            if (discoveryConfigProperty.getType().isMap()) {
                if (discoveryConfigProperty.isUnnamedMapKey()) {
                    ListIterator<CallSite> additionalPathsIterator = additionalPaths.listIterator();
                    additionalPathsIterator.add((CallSite)((Object)(path + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey()))));
                    while (additionalPathsIterator.hasNext()) {
                        additionalPathsIterator.add((CallSite)((Object)((String)additionalPathsIterator.next() + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey()))));
                    }
                } else {
                    potentiallyMappedPath = (String)potentiallyMappedPath + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey());
                    additionalPaths = additionalPaths.stream().map(p -> p + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey())).collect(Collectors.toCollection(ArrayList::new));
                }
            }
            boolean isWithinMap = context.isWithinMap() || discoveryConfigProperty.getType().isMap();
            boolean bl = isWithMapWithUnnamedKey = context.isWithinMapWithUnnamedKey() || discoveryConfigProperty.isUnnamedMapKey();
            if (discoveryConfigProperty.isSection()) {
                Object configSection = existingRootConfigSections.get(path);
                if (configSection != null) {
                    ((ConfigSection)configSection).appendState(discoveryConfigProperty.isSectionGenerated(), deprecation);
                } else {
                    configSection = new ConfigSection(discoveryConfigProperty.getSourceType(), discoveryConfigProperty.getSourceElementName(), discoveryConfigProperty.getSourceElementType(), new ConfigSection.SectionPath(path), typeQualifiedName, context.getSectionLevel(), discoveryConfigProperty.isSectionGenerated(), deprecation);
                    context.getItemCollection().addItem((AbstractConfigItem)configSection);
                    existingRootConfigSections.put(path, (ConfigSection)configSection);
                }
                configGroupContext = new ResolutionContext((String)potentiallyMappedPath, additionalPaths, discoveryConfigGroup, (ConfigItemCollection)configSection, context.getSectionLevel() + 1, isWithinMap, isWithMapWithUnnamedKey, deprecation);
            } else {
                configGroupContext = new ResolutionContext((String)potentiallyMappedPath, additionalPaths, discoveryConfigGroup, context.getItemCollection(), context.getSectionLevel(), isWithinMap, isWithMapWithUnnamedKey, deprecation);
            }
            for (DiscoveryConfigProperty configGroupProperty : discoveryConfigGroup.getProperties().values()) {
                this.resolveProperty(configRoot, existingRootConfigSections, phase, configGroupContext, configGroupProperty);
            }
        } else {
            String typeBinaryName = discoveryConfigProperty.getType().binaryName();
            String typeSimplifiedName = discoveryConfigProperty.getType().simplifiedName();
            boolean hyphenateEnumValues = discoveryConfigProperty.isEnforceHyphenateEnumValue() || !discoveryConfigProperty.isConverted();
            String defaultValue = ConfigResolver.getDefaultValue(discoveryConfigProperty.getDefaultValue(), discoveryConfigProperty.getDefaultValueForDoc(), discoveryConfigProperty.getType(), hyphenateEnumValues);
            EnumAcceptedValues enumAcceptedValues = null;
            if (discoveryConfigProperty.getType().isEnum()) {
                EnumDefinition enumDefinition = this.configCollector.getResolvedEnum(typeQualifiedName);
                Map localAcceptedValues = enumDefinition.constants().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new EnumAcceptedValues.EnumAcceptedValue(((EnumDefinition.EnumConstant)e.getValue()).hasExplicitValue() ? ((EnumDefinition.EnumConstant)e.getValue()).explicitValue() : (hyphenateEnumValues ? ConfigNamingUtil.hyphenateEnumValue((String)e.getKey()) : (String)e.getKey())), (x, y) -> y, LinkedHashMap::new));
                enumAcceptedValues = new EnumAcceptedValues(enumDefinition.qualifiedName(), localAcceptedValues);
            }
            Object potentiallyMappedPath = path;
            boolean optional = discoveryConfigProperty.getType().isOptional();
            if (discoveryConfigProperty.getType().isMap()) {
                optional = true;
                typeQualifiedName = this.utils.element().getQualifiedName(discoveryConfigProperty.getType().wrapperType());
                typeSimplifiedName = this.utils.element().simplifyGenericType(discoveryConfigProperty.getType().wrapperType());
                potentiallyMappedPath = (String)potentiallyMappedPath + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey());
                additionalPaths = additionalPaths.stream().map(p -> p + ConfigNamingUtil.getMapKey(discoveryConfigProperty.getMapKey())).collect(Collectors.toCollection(ArrayList::new));
            } else if (discoveryConfigProperty.getType().isList()) {
                typeQualifiedName = this.utils.element().getQualifiedName(discoveryConfigProperty.getType().wrapperType());
            }
            ConfigProperty.PropertyPath propertyPath = new ConfigProperty.PropertyPath((String)potentiallyMappedPath, ConfigNamingUtil.toEnvVarName((String)potentiallyMappedPath));
            List<ConfigProperty.PropertyPath> additionalPropertyPaths = additionalPaths.stream().map(ap -> new ConfigProperty.PropertyPath((String)ap, ConfigNamingUtil.toEnvVarName(ap))).toList();
            ConfigProperty configProperty = new ConfigProperty(phase, discoveryConfigProperty.getSourceType(), discoveryConfigProperty.getSourceElementName(), discoveryConfigProperty.getSourceElementType(), propertyPath, additionalPropertyPaths, typeQualifiedName, typeSimplifiedName, discoveryConfigProperty.getType().isMap(), discoveryConfigProperty.getType().isList(), optional, discoveryConfigProperty.getMapKey(), discoveryConfigProperty.isUnnamedMapKey(), context.isWithinMap(), discoveryConfigProperty.isConverted(), discoveryConfigProperty.getType().isEnum(), enumAcceptedValues, defaultValue, JavadocUtil.getJavadocSiteLink(typeBinaryName), deprecation);
            context.getItemCollection().addItem(configProperty);
        }
    }

    public static String getDefaultValue(String defaultValue, String defaultValueForDoc, ResolvedType type, boolean hyphenateEnumValues) {
        if (!Strings.isBlank(defaultValueForDoc)) {
            return defaultValueForDoc;
        }
        if (defaultValue == null) {
            return null;
        }
        if (type.isEnum() && hyphenateEnumValues) {
            if (type.isList()) {
                return Arrays.stream(defaultValue.split(",")).map(v -> ConfigNamingUtil.hyphenateEnumValue(v.trim())).collect(Collectors.joining(","));
            }
            return ConfigNamingUtil.hyphenateEnumValue(defaultValue.trim());
        }
        return defaultValue;
    }

    public static String getType(TypeMirror typeMirror) {
        if (typeMirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return typeMirror.toString();
    }

    public static String appendPath(String parentPath, String path) {
        return "<<parent>>".equals(path) ? parentPath : parentPath + "." + path;
    }

    private static class ResolutionContext {
        private final String path;
        private final List<String> additionalPaths;
        private final DiscoveryRootElement discoveryRootElement;
        private final ConfigItemCollection itemCollection;
        private final int sectionLevel;
        private final boolean withinMap;
        private final boolean withinMapWithUnnamedKey;
        private final Deprecation deprecation;

        private ResolutionContext(String path, List<String> additionalPaths, DiscoveryRootElement discoveryRootElement, ConfigItemCollection itemCollection, int sectionLevel, boolean withinMap, boolean withinMapWithUnnamedKey, Deprecation deprecation) {
            this.path = path;
            this.additionalPaths = additionalPaths;
            this.discoveryRootElement = discoveryRootElement;
            this.itemCollection = itemCollection;
            this.withinMap = withinMap;
            this.withinMapWithUnnamedKey = withinMapWithUnnamedKey;
            this.deprecation = deprecation;
            this.sectionLevel = sectionLevel;
        }

        public String getPath() {
            return this.path;
        }

        public List<String> getAdditionalPaths() {
            return this.additionalPaths;
        }

        public DiscoveryRootElement getDiscoveryRootElement() {
            return this.discoveryRootElement;
        }

        public ConfigItemCollection getItemCollection() {
            return this.itemCollection;
        }

        public int getSectionLevel() {
            return this.sectionLevel;
        }

        public boolean isWithinMap() {
            return this.withinMap;
        }

        public boolean isWithinMapWithUnnamedKey() {
            return this.withinMapWithUnnamedKey;
        }

        public Deprecation getDeprecation() {
            return this.deprecation;
        }
    }
}

