/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadoc;
import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadocSection;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.scanner.AbstractJavadocConfigListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.JavadocUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class JavadocLegacyConfigRootListener
extends AbstractJavadocConfigListener {
    JavadocLegacyConfigRootListener(Config config, Utils utils, ConfigCollector configCollector) {
        super(config, utils, configCollector);
    }

    @Override
    public void onEnclosedField(DiscoveryRootElement discoveryRootElement, TypeElement clazz, VariableElement field, ResolvedType resolvedType) {
        if (this.config.getExtension().isMixedModule() && discoveryRootElement.isConfigMapping()) {
            return;
        }
        if (!this.utils.element().isLocalClass(clazz)) {
            return;
        }
        String rawJavadoc = this.utils.element().getJavadoc(field).orElse("");
        boolean isSection = this.utils.element().isAnnotationPresent(field, "io.quarkus.runtime.annotations.ConfigDocSection");
        if (isSection) {
            ParsedJavadocSection parsedJavadocSection = JavadocUtil.parseConfigSectionJavadoc(rawJavadoc);
            if (parsedJavadocSection.title() == null) {
                return;
            }
            this.configCollector.addJavadocElement(clazz.getQualifiedName().toString() + "." + field.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadocSection.title(), parsedJavadocSection.format(), null, parsedJavadocSection.deprecated()));
        } else {
            ParsedJavadoc parsedJavadoc = JavadocUtil.parseConfigItemJavadoc(rawJavadoc);
            if (parsedJavadoc.description() == null) {
                if (parsedJavadoc.deprecated() == null && !resolvedType.isConfigGroup()) {
                    this.utils.element().addMissingJavadocError(field);
                }
                return;
            }
            this.configCollector.addJavadocElement(clazz.getQualifiedName().toString() + "." + field.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadoc.description(), parsedJavadoc.format(), parsedJavadoc.since(), parsedJavadoc.deprecated()));
        }
    }
}

