/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigDocKey;
import io.quarkus.annotation.processor.generate_doc.ConfigDocSection;
import io.quarkus.annotation.processor.generate_doc.ConfigPhase;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class DocGeneratorUtil {
    private static final String CORE = "core";
    private static final String CONFIG = "Config";
    private static final String CONFIGURATION = "Configuration";
    private static String CONFIG_GROUP_DOC_PREFIX = "config-group-";
    static final String VERTX_JAVA_DOC_SITE = "https://vertx.io/docs/apidocs/";
    static final String OFFICIAL_JAVA_DOC_BASE_LINK = "https://docs.oracle.com/javase/8/docs/api/";
    static final String AGROAL_API_JAVA_DOC_SITE = "https://jar-download.com/javaDoc/io.agroal/agroal-api/1.5/index.html?";
    private static final Map<String, String> JAVA_PRIMITIVE_WRAPPERS = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_DEFAULT_VALUES = new HashMap<String, String>();
    private static final Map<String, String> EXTENSION_JAVA_DOC_LINK = new HashMap<String, String>();
    private static Pattern PACKAGE_PATTERN = Pattern.compile("^(\\w+)\\.(\\w+)\\..*$");
    private static final String HYPHEN = "-";
    private static final Pattern PATTERN = Pattern.compile("([-_]+)");

    static String getPrimitiveDefaultValue(String primitiveType) {
        return PRIMITIVE_DEFAULT_VALUES.get(primitiveType);
    }

    static String unbox(String type) {
        String mapping = JAVA_PRIMITIVE_WRAPPERS.get(type);
        return mapping == null ? type : mapping;
    }

    static String getJavaDocSiteLink(String type) {
        Matcher packageMatcher = PACKAGE_PATTERN.matcher(type);
        if (!packageMatcher.find()) {
            return "";
        }
        if (JAVA_PRIMITIVE_WRAPPERS.containsKey(type)) {
            return "";
        }
        if ("java".equals(packageMatcher.group(1))) {
            return OFFICIAL_JAVA_DOC_BASE_LINK + DocGeneratorUtil.getJavaDocLinkForType(type);
        }
        String basePkgName = packageMatcher.group(1) + "." + packageMatcher.group(2) + ".";
        String javaDocBaseUrl = EXTENSION_JAVA_DOC_LINK.get(basePkgName);
        if (javaDocBaseUrl != null) {
            return javaDocBaseUrl + DocGeneratorUtil.getJavaDocLinkForType(type);
        }
        return "";
    }

    private static String getJavaDocLinkForType(String type) {
        int beginOfWrappedTypeIndex = type.indexOf("<");
        if (beginOfWrappedTypeIndex != -1) {
            type = type.substring(0, beginOfWrappedTypeIndex);
        }
        int indexOfFirstUpperCase = 0;
        for (int index = 0; index < type.length(); ++index) {
            char charAt = type.charAt(index);
            if (charAt < 'A' || charAt > 'Z') continue;
            indexOfFirstUpperCase = index;
            break;
        }
        String base = type.substring(0, indexOfFirstUpperCase).replace('.', '/');
        String html = type.substring(indexOfFirstUpperCase).replace('$', '.') + ".html";
        return base + html;
    }

    static String getKnownGenericType(DeclaredType declaredType) {
        return Constants.ALIASED_TYPES.get(declaredType.toString());
    }

    static Iterator<String> camelHumpsIterator(final String str) {
        return new Iterator<String>(){
            int idx;

            @Override
            public boolean hasNext() {
                return this.idx < str.length();
            }

            @Override
            public String next() {
                if (this.idx == str.length()) {
                    throw new NoSuchElementException();
                }
                if (str.startsWith("JBoss", this.idx)) {
                    this.idx += 5;
                    return "JBoss";
                }
                int start = this.idx;
                int c = str.codePointAt(this.idx);
                if (Character.isUpperCase(c)) {
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                    if (this.idx < str.length()) {
                        c = str.codePointAt(this.idx);
                        if (Character.isUpperCase(c)) {
                            int nextIdx = str.offsetByCodePoints(this.idx, 1);
                            while (nextIdx < str.length()) {
                                c = str.codePointAt(nextIdx);
                                if (Character.isLowerCase(c)) {
                                    return str.substring(start, this.idx);
                                }
                                this.idx = nextIdx;
                                nextIdx = str.offsetByCodePoints(this.idx, 1);
                            }
                            this.idx = str.length();
                            return str.substring(start);
                        }
                        this.idx = str.offsetByCodePoints(this.idx, 1);
                        while (this.idx < str.length()) {
                            c = str.codePointAt(this.idx);
                            if (Character.isUpperCase(c)) {
                                return str.substring(start, this.idx);
                            }
                            this.idx = str.offsetByCodePoints(this.idx, 1);
                        }
                        return str.substring(start);
                    }
                    return str.substring(start);
                }
                this.idx = str.offsetByCodePoints(this.idx, 1);
                while (this.idx < str.length()) {
                    c = str.codePointAt(this.idx);
                    if (Character.isUpperCase(c)) {
                        return str.substring(start, this.idx);
                    }
                    this.idx = str.offsetByCodePoints(this.idx, 1);
                }
                return str.substring(start);
            }
        };
    }

    static Iterator<String> lowerCase(final Iterator<String> orig) {
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return orig.hasNext();
            }

            @Override
            public String next() {
                return ((String)orig.next()).toLowerCase(Locale.ROOT);
            }
        };
    }

    static String join(Iterator<String> it) {
        StringBuilder b = new StringBuilder();
        if (it.hasNext()) {
            b.append(it.next());
            while (it.hasNext()) {
                b.append(HYPHEN);
                b.append(it.next());
            }
        }
        return b.toString();
    }

    static String hyphenate(String orig) {
        return DocGeneratorUtil.join(DocGeneratorUtil.lowerCase(DocGeneratorUtil.camelHumpsIterator(orig)));
    }

    static String hyphenateEnumValue(String orig) {
        StringBuffer target = new StringBuffer();
        String hyphenate = DocGeneratorUtil.hyphenate(orig);
        Matcher matcher = PATTERN.matcher(hyphenate);
        while (matcher.find()) {
            matcher.appendReplacement(target, HYPHEN);
        }
        matcher.appendTail(target);
        return target.toString();
    }

    static String joinAcceptedValues(List<String> acceptedValues) {
        if (acceptedValues == null || acceptedValues.isEmpty()) {
            return "";
        }
        return acceptedValues.stream().collect(Collectors.joining("`, `", "`", "`"));
    }

    static String getTypeFormatInformationNote(ConfigDocKey configDocKey) {
        if (configDocKey.getType().equals(Duration.class.getName())) {
            return Constants.DURATION_INFORMATION;
        }
        if (configDocKey.getType().equals("io.quarkus.runtime.configuration.MemorySize")) {
            return Constants.MEMORY_SIZE_INFORMATION;
        }
        return "";
    }

    static boolean hasDurationInformationNote(ConfigDocKey configDocKey) {
        return configDocKey.hasType() && configDocKey.getType().equals(Duration.class.getName());
    }

    static boolean hasMemoryInformationNote(ConfigDocKey configDocKey) {
        return configDocKey.hasType() && configDocKey.getType().equals("io.quarkus.runtime.configuration.MemorySize");
    }

    public static String computeExtensionDocFileName(String configRoot) {
        StringBuilder extensionNameBuilder = new StringBuilder();
        Matcher matcher = Constants.PKG_PATTERN.matcher(configRoot);
        if (!matcher.find()) {
            extensionNameBuilder.append(configRoot);
        } else {
            String extensionName = matcher.group(1);
            String subgroup = matcher.group(2);
            extensionNameBuilder.append("quarkus");
            extensionNameBuilder.append(HYPHEN);
            if ("deployment".equals(extensionName) || "runtime".equals(extensionName)) {
                extensionNameBuilder.append(CORE);
            } else if (subgroup != null && !"deployment".equals(subgroup) && !"runtime".equals(subgroup) && !"common".equals(subgroup) && subgroup.matches("^[a-z0-9]+$")) {
                extensionNameBuilder.append(extensionName);
                extensionNameBuilder.append(HYPHEN);
                extensionNameBuilder.append(subgroup);
                String qualifier = matcher.group(3);
                if (qualifier != null && !"deployment".equals(qualifier) && !"runtime".equals(qualifier) && !"common".equals(qualifier) && qualifier.matches("^[a-z0-9]+$")) {
                    extensionNameBuilder.append(HYPHEN);
                    extensionNameBuilder.append(qualifier);
                }
            } else {
                extensionNameBuilder.append(extensionName);
            }
        }
        extensionNameBuilder.append(".adoc");
        return extensionNameBuilder.toString();
    }

    public static String computeExtensionGeneralConfigDocFileName(String configRoot) {
        StringBuilder extensionNameBuilder = new StringBuilder();
        Matcher matcher = Constants.PKG_PATTERN.matcher(configRoot);
        if (!matcher.find()) {
            extensionNameBuilder.append(configRoot);
        } else {
            String extensionName = matcher.group(1);
            String subgroup = matcher.group(2);
            extensionNameBuilder.append("quarkus");
            extensionNameBuilder.append(HYPHEN);
            if ("deployment".equals(extensionName) || "runtime".equals(extensionName)) {
                extensionNameBuilder.append(CORE);
            } else if (subgroup != null && !"deployment".equals(subgroup) && !"runtime".equals(subgroup) && !"common".equals(subgroup) && subgroup.matches("^[a-z0-9]+$")) {
                extensionNameBuilder.append(extensionName);
                extensionNameBuilder.append(HYPHEN);
                extensionNameBuilder.append(subgroup);
                String qualifier = matcher.group(3);
                if (qualifier != null && !"deployment".equals(qualifier) && !"runtime".equals(qualifier) && !"common".equals(qualifier) && qualifier.matches("^[a-z0-9]+$")) {
                    extensionNameBuilder.append(HYPHEN);
                    extensionNameBuilder.append(qualifier);
                }
            } else {
                extensionNameBuilder.append(extensionName);
            }
        }
        extensionNameBuilder.append(".adoc");
        return extensionNameBuilder.toString();
    }

    public static String computeConfigGroupDocFileName(String configGroupClassName) {
        String sanitizedClassName;
        Matcher matcher = Constants.PKG_PATTERN.matcher(configGroupClassName);
        if (!matcher.find()) {
            sanitizedClassName = CONFIG_GROUP_DOC_PREFIX + HYPHEN + DocGeneratorUtil.hyphenate(configGroupClassName);
        } else {
            String replacement = HYPHEN + CONFIG_GROUP_DOC_PREFIX + HYPHEN;
            sanitizedClassName = configGroupClassName.replaceFirst("io.", "").replaceFirst("\\.runtime\\.", replacement).replaceFirst("\\.deployment\\.", replacement);
        }
        return DocGeneratorUtil.hyphenate(sanitizedClassName).replaceAll("[\\.-]+", HYPHEN) + ".adoc";
    }

    public static String computeConfigRootDocFileName(String configRootClassName, String rootName) {
        String sanitizedClassName;
        Matcher matcher = Constants.PKG_PATTERN.matcher(configRootClassName);
        if (!matcher.find()) {
            sanitizedClassName = rootName + HYPHEN + DocGeneratorUtil.hyphenate(configRootClassName);
        } else {
            String deployment = ".deployment.";
            String runtime = ".runtime.";
            sanitizedClassName = configRootClassName.contains(deployment) ? configRootClassName.substring(configRootClassName.indexOf(deployment) + deployment.length()) : (configRootClassName.contains(runtime) ? configRootClassName.substring(configRootClassName.indexOf(runtime) + runtime.length()) : configRootClassName.replaceFirst("io.quarkus.", ""));
            sanitizedClassName = rootName + HYPHEN + sanitizedClassName;
        }
        return DocGeneratorUtil.hyphenate(sanitizedClassName).replaceAll("[\\.-]+", HYPHEN) + ".adoc";
    }

    public static void appendConfigItemsIntoExistingOnes(List<ConfigDocItem> existingConfigItems, List<ConfigDocItem> configDocItems) {
        for (ConfigDocItem configDocItem : configDocItems) {
            if (configDocItem.isConfigKey()) {
                existingConfigItems.add(configDocItem);
                continue;
            }
            ConfigDocSection configDocSection = configDocItem.getConfigDocSection();
            boolean configSectionMerged = DocGeneratorUtil.mergeSectionIntoPreviousExistingConfigItems(configDocSection, existingConfigItems);
            if (configSectionMerged) continue;
            existingConfigItems.add(configDocItem);
        }
    }

    private static boolean mergeSectionIntoPreviousExistingConfigItems(ConfigDocSection section, List<ConfigDocItem> configDocItems) {
        for (ConfigDocItem configDocItem : configDocItems) {
            if (configDocItem.isConfigKey()) continue;
            ConfigDocSection configDocSection = configDocItem.getConfigDocSection();
            if (configDocSection.equals(section)) {
                configDocSection.addConfigDocItems(section.getConfigDocItems());
                return true;
            }
            boolean configSectionMerged = DocGeneratorUtil.mergeSectionIntoPreviousExistingConfigItems(section, configDocSection.getConfigDocItems());
            if (!configSectionMerged) continue;
            return true;
        }
        return false;
    }

    static String stringifyType(TypeMirror typeMirror) {
        List<? extends TypeMirror> typeArguments = ((DeclaredType)typeMirror).getTypeArguments();
        String simpleName = DocGeneratorUtil.typeSimpleName(typeMirror);
        if (typeArguments.isEmpty()) {
            return simpleName;
        }
        if (typeArguments.size() == 1) {
            return String.format("%s<%s>", simpleName, DocGeneratorUtil.stringifyType(typeArguments.get(0)));
        }
        if (typeArguments.size() == 2) {
            return String.format("%s<%s,%s>", simpleName, DocGeneratorUtil.stringifyType(typeArguments.get(0)), DocGeneratorUtil.stringifyType(typeArguments.get(1)));
        }
        return "unknown";
    }

    private static String typeSimpleName(TypeMirror typeMirror) {
        String type = ((DeclaredType)typeMirror).asElement().toString();
        return type.substring(1 + type.lastIndexOf(46));
    }

    static String deriveConfigRootName(String simpleClassName, ConfigPhase configPhase) {
        String simpleNameInLowerCase = simpleClassName.toLowerCase();
        int length = simpleNameInLowerCase.length();
        if (simpleNameInLowerCase.endsWith(CONFIG.toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - CONFIG.length());
            return DocGeneratorUtil.deriveConfigRootName(sanitized, configPhase);
        }
        if (simpleNameInLowerCase.endsWith(CONFIGURATION.toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - CONFIGURATION.length());
            return DocGeneratorUtil.deriveConfigRootName(sanitized, configPhase);
        }
        if (simpleNameInLowerCase.endsWith(configPhase.getConfigSuffix().toLowerCase())) {
            String sanitized = simpleClassName.substring(0, length - configPhase.getConfigSuffix().length());
            return DocGeneratorUtil.deriveConfigRootName(sanitized, configPhase);
        }
        return "quarkus." + DocGeneratorUtil.hyphenate(simpleClassName);
    }

    public static void sort(List<ConfigDocItem> configDocItems) {
        Collections.sort(configDocItems);
        for (ConfigDocItem configDocItem : configDocItems) {
            if (!configDocItem.isConfigSection()) continue;
            DocGeneratorUtil.sort(configDocItem.getConfigDocSection().getConfigDocItems());
        }
    }

    static {
        PRIMITIVE_DEFAULT_VALUES.put("int", "0");
        PRIMITIVE_DEFAULT_VALUES.put("byte", "0");
        PRIMITIVE_DEFAULT_VALUES.put("char", "");
        PRIMITIVE_DEFAULT_VALUES.put("short", "0");
        PRIMITIVE_DEFAULT_VALUES.put("long", "0l");
        PRIMITIVE_DEFAULT_VALUES.put("float", "0f");
        PRIMITIVE_DEFAULT_VALUES.put("double", "0d");
        PRIMITIVE_DEFAULT_VALUES.put("boolean", "false");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Character", "char");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Boolean", "boolean");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Byte", "byte");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Short", "short");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Integer", "int");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Long", "long");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Float", "float");
        JAVA_PRIMITIVE_WRAPPERS.put("java.lang.Double", "double");
        EXTENSION_JAVA_DOC_LINK.put("io.vertx.", VERTX_JAVA_DOC_SITE);
        EXTENSION_JAVA_DOC_LINK.put("io.agroal.", AGROAL_API_JAVA_DOC_SITE);
    }
}

