/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;

public class DefaultRoleDecoder {
    @ConfigProperty(name="quarkus.security.roles-claim-name", defaultValue="groups")
    String groupsAttribute;
    @Inject
    @Any
    private Instance<RoleDecoder> userInstances;

    public Roles decodeRoles(AuthorizationIdentity authorizationIdentity) {
        if (this.userInstances.isUnsatisfied()) {
            return this.fromDefaultAttribute(authorizationIdentity);
        }
        if (this.userInstances.isAmbiguous()) {
            ArrayList<Roles> allRoles = new ArrayList<Roles>();
            for (RoleDecoder i : this.userInstances) {
                allRoles.add(i.decodeRoles(authorizationIdentity));
            }
            Roles r = (Roles)allRoles.get(0);
            for (int i = 1; i < allRoles.size(); ++i) {
                r = r.or((Roles)allRoles.get(i));
            }
            return r;
        }
        return ((RoleDecoder)this.userInstances.get()).decodeRoles(authorizationIdentity);
    }

    Roles fromDefaultAttribute(AuthorizationIdentity authorizationIdentity) {
        Attributes.Entry groups = authorizationIdentity.getAttributes().get(this.groupsAttribute);
        if (groups == null) {
            return Roles.NONE;
        }
        return Roles.fromSet(new HashSet(groups));
    }
}

