/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.elytron.security.runtime.DefaultRoleDecoder;
import io.quarkus.elytron.security.runtime.ElytronSecurityDomainManager;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.security.Permission;
import java.security.Provider;
import java.security.Security;
import javax.enterprise.inject.spi.CDI;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.PermissionMappable;
import org.wildfly.security.authz.PermissionMapper;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.permission.PermissionVerifier;

@Recorder
public class ElytronRecorder {
    static final Logger log = Logger.getLogger(ElytronRecorder.class);

    public void runLoadTask(Runnable runnable) {
        runnable.run();
    }

    public void setDomainForIdentityProvider(BeanContainer bc, RuntimeValue<SecurityDomain> domain) {
        ((ElytronSecurityDomainManager)bc.instance(ElytronSecurityDomainManager.class, new Annotation[0])).setDomain((SecurityDomain)domain.getValue());
    }

    public RuntimeValue<SecurityDomain.Builder> configureDomainBuilder(String realmName, RuntimeValue<SecurityRealm> realm) throws Exception {
        log.debugf("buildDomain, realm=%s", realm.getValue());
        SecurityDomain.Builder domain = SecurityDomain.builder().addRealm(realmName, (SecurityRealm)realm.getValue()).setRoleDecoder(new RoleDecoder(){

            public Roles decodeRoles(AuthorizationIdentity authorizationIdentity) {
                return ((DefaultRoleDecoder)CDI.current().select(DefaultRoleDecoder.class, new Annotation[0]).get()).decodeRoles(authorizationIdentity);
            }
        }).build().setDefaultRealmName(realmName).setPermissionMapper(new PermissionMapper(){

            public PermissionVerifier mapPermissions(PermissionMappable permissionMappable, Roles roles) {
                return new PermissionVerifier(){

                    public boolean implies(Permission permission) {
                        return true;
                    }
                };
            }
        });
        return new RuntimeValue((Object)domain);
    }

    public void addRealm(RuntimeValue<SecurityDomain.Builder> builder, String realmName, RuntimeValue<SecurityRealm> realm) {
        ((SecurityDomain.Builder)builder.getValue()).addRealm(realmName, (SecurityRealm)realm.getValue());
    }

    public RuntimeValue<SecurityDomain> buildDomain(RuntimeValue<SecurityDomain.Builder> builder) {
        return new RuntimeValue((Object)((SecurityDomain.Builder)builder.getValue()).build());
    }

    public void registerPasswordProvider(ShutdownContext context) {
        final WildFlyElytronPasswordProvider provider = new WildFlyElytronPasswordProvider();
        context.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                Security.removeProvider(provider.getName());
            }
        });
        Security.addProvider((Provider)provider);
    }
}

