/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.runtime;

import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.quarkus.vertx.http.runtime.security.TrustedAuthenticationRequest;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;

@ApplicationScoped
public class ElytronTrustedIdentityProvider
implements IdentityProvider<TrustedAuthenticationRequest> {
    private static Logger log = Logger.getLogger(ElytronTrustedIdentityProvider.class);
    @Inject
    SecurityDomain domain;

    public Class<TrustedAuthenticationRequest> getRequestType() {
        return TrustedAuthenticationRequest.class;
    }

    public CompletionStage<io.quarkus.security.identity.SecurityIdentity> authenticate(final TrustedAuthenticationRequest request, AuthenticationRequestContext context) {
        return context.runBlocking((Supplier)new Supplier<io.quarkus.security.identity.SecurityIdentity>(){

            @Override
            public io.quarkus.security.identity.SecurityIdentity get() {
                try {
                    RealmIdentity id = ElytronTrustedIdentityProvider.this.domain.getIdentity(request.getPrincipal());
                    if (!id.exists()) {
                        return null;
                    }
                    PasswordCredential cred = (PasswordCredential)id.getCredential(PasswordCredential.class);
                    ServerAuthenticationContext ac = ElytronTrustedIdentityProvider.this.domain.createNewAuthenticationContext();
                    ac.setAuthenticationName(request.getPrincipal());
                    ac.addPrivateCredential((Credential)cred);
                    ac.authorize();
                    SecurityIdentity result = ac.getAuthorizedIdentity();
                    if (result == null) {
                        throw new AuthenticationFailedException();
                    }
                    QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
                    builder.setPrincipal(result.getPrincipal());
                    for (String i : result.getRoles()) {
                        builder.addRole(i);
                    }
                    return builder.build();
                }
                catch (RealmUnavailableException e) {
                    throw new RuntimeException(e);
                }
                catch (SecurityException e) {
                    log.debug((Object)"Authentication failed", (Throwable)e);
                    throw new AuthenticationFailedException();
                }
            }
        });
    }
}

