/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.oauth2.runtime.auth;

import java.security.Principal;
import java.util.Map;
import java.util.Optional;

public class ElytronOAuth2CallerPrincipal
implements Principal {
    private Map<String, Object> claims;
    private String customPrincipalName;

    public ElytronOAuth2CallerPrincipal(String customPrincipalName, Map<String, Object> claims) {
        this.claims = claims;
        this.customPrincipalName = customPrincipalName;
    }

    public ElytronOAuth2CallerPrincipal(Map<String, Object> claims) {
        this("username", claims);
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    @Override
    public String getName() {
        return this.getClaimValueAsString(this.customPrincipalName).orElseGet(() -> this.getClaimValueAsString("client_id").orElse(null));
    }

    private Optional<String> getClaimValueAsString(String key) {
        if (this.getClaims().containsKey(key)) {
            return Optional.of((String)this.getClaims().get(key));
        }
        return Optional.empty();
    }
}

