/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.javaclient.runtime.graalvm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class ElasticsearchJavaClientFeature
implements Feature {
    private static final String BUILDER_BASE_CLASS_NAME = "co.elastic.clients.util.WithJsonObjectBuilderBase";
    private static final boolean log = Boolean.getBoolean("io.quarkus.elasticsearch.javaclient.graalvm.diagnostics");

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Method withJsonMethod;
        Class builderClass = access.findClassByName(BUILDER_BASE_CLASS_NAME);
        try {
            withJsonMethod = builderClass.getMethod("withJson", JsonParser.class, JsonpMapper.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not find co.elastic.clients.util.WithJsonObjectBuilderBase#withJson(...); does the version of Elasticsearch Java Client match the version specified in the Quarkus BOM?");
        }
        access.registerReachabilityHandler(this::onWithJsonReachable, new Object[]{withJsonMethod});
    }

    private void onWithJsonReachable(Feature.DuringAnalysisAccess access) {
        this.logf("%s#withJson(...) is reachable", BUILDER_BASE_CLASS_NAME);
        for (Class builderSubClass : access.reachableSubtypes(WithJsonObjectBuilderBase.class)) {
            this.enableBuilderWithJson(builderSubClass, access);
        }
    }

    private void enableBuilderWithJson(Class<?> builderSubClass, Feature.DuringAnalysisAccess access) {
        if (Modifier.isAbstract(builderSubClass.getModifiers())) {
            return;
        }
        Class<?> builtClass = builderSubClass.getEnclosingClass();
        if (builtClass == null) {
            this.logf("Could not guess the class built by %s", builderSubClass);
            return;
        }
        JsonpDeserializable deserializable = builtClass.getAnnotation(JsonpDeserializable.class);
        if (deserializable == null) {
            this.logf("Could not find @JsonpDeserializable on %s for builder %s", builtClass, builderSubClass);
            return;
        }
        String fieldName = deserializable.field();
        try {
            Field field = builtClass.getDeclaredField(fieldName);
            this.logf("Registering deserializer field %s as accessed in %s", fieldName, builtClass);
            access.registerAsAccessed(field);
            RuntimeReflection.register((Field[])new Field[]{field});
        }
        catch (NoSuchFieldException e) {
            this.logf("Could not find deserializer field %s in %s", fieldName, builtClass);
        }
    }

    private void logf(String message, Object ... args) {
        if (!log) {
            return;
        }
        System.out.printf("Quarkus's automatic feature for Elasticsearch Java Client: " + message + "\n", args);
    }

    public String getDescription() {
        return "Support for Elasticsearch Java Client's withJson() methods in builders";
    }
}

