/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.quarkus.devui.runtime.DevUIFilterHelper;
import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.quarkus.vertx.http.runtime.cors.CORSFilter;
import io.quarkus.vertx.http.security.CORS;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevUICORSFilter
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(DevUICORSFilter.class);
    private static final String HTTP_PORT_CONFIG_PROP = "quarkus.http.port";
    private static final String HTTPS_PORT_CONFIG_PROP = "quarkus.http.ssl-port";
    private static final String LOCAL_HOST = "localhost";
    private static final String LOCAL_HOST_IP = "127.0.0.1";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String HTTP_LOCAL_HOST = "http://localhost";
    private static final String HTTPS_LOCAL_HOST = "https://localhost";
    private static final String HTTP_LOCAL_HOST_IP = "http://127.0.0.1";
    private static final String HTTPS_LOCAL_HOST_IP = "https://127.0.0.1";
    private static final String CHROME_EXTENSION = "chrome-extension://";
    private final List<String> hosts;
    private final List<Pattern> hostsPatterns;
    private volatile CORSConfig baseCorsConfig;

    public DevUICORSFilter(List<String> hosts) {
        this.hosts = hosts;
        this.hostsPatterns = DevUIFilterHelper.detectPatterns(this.hosts);
        this.baseCorsConfig = null;
    }

    private CORSFilter corsFilter(String allowedHost) {
        CORSConfig corsConfig = allowedHost == null ? this.getBaseCorsConfig() : this.createCorsConfig(allowedHost);
        return new CORSFilter(corsConfig);
    }

    public void handle(RoutingContext event) {
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null || this.isLocalHost(origin)) {
            this.corsFilter(null).handle(event);
        } else if (this.isConfiguredHost(origin) || this.isConfiguredHostPattern(origin)) {
            this.corsFilter(origin).handle(event);
        } else {
            if (!origin.startsWith(CHROME_EXTENSION)) {
                LOG.errorf("Only localhost origin is allowed, but Origin header value is: %s", (Object)origin);
            }
            response.setStatusCode(403);
            response.setStatusMessage("CORS Rejected - Invalid origin");
            response.end();
        }
    }

    private boolean isLocalHost(String origin) {
        return origin.startsWith(HTTP_LOCAL_HOST) || origin.startsWith(HTTPS_LOCAL_HOST) || origin.startsWith(HTTP_LOCAL_HOST_IP) || origin.startsWith(HTTPS_LOCAL_HOST_IP);
    }

    private boolean isConfiguredHost(String origin) {
        if (this.hosts != null) {
            for (String configuredHost : this.hosts) {
                if (!origin.startsWith(HTTP + configuredHost) && !origin.startsWith(HTTPS + configuredHost)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isConfiguredHostPattern(String origin) {
        if (this.hostsPatterns != null && !this.hostsPatterns.isEmpty()) {
            for (Pattern pat : this.hostsPatterns) {
                Matcher matcher = pat.matcher(origin);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private CORSConfig getBaseCorsConfig() {
        if (this.baseCorsConfig == null) {
            int httpPort = (Integer)ConfigProvider.getConfig().getValue(HTTP_PORT_CONFIG_PROP, Integer.TYPE);
            int httpsPort = (Integer)ConfigProvider.getConfig().getValue(HTTPS_PORT_CONFIG_PROP, Integer.TYPE);
            this.baseCorsConfig = (CORSConfig)CORS.origins(Set.of("http://localhost:" + httpPort, "https://localhost:" + httpsPort, "http://127.0.0.1:" + httpPort, "https://127.0.0.1:" + httpsPort)).build();
        }
        return this.baseCorsConfig;
    }

    private CORSConfig createCorsConfig(String allowedHost) {
        final CORSConfig baseCorsconfig = this.getBaseCorsConfig();
        ArrayList<String> listOfOrigins = new ArrayList<String>((Collection)baseCorsconfig.origins().get());
        listOfOrigins.add(allowedHost);
        final Optional origins = Optional.of(Collections.unmodifiableList(listOfOrigins));
        return new CORSConfig(){

            public boolean enabled() {
                return true;
            }

            public Optional<List<String>> origins() {
                return origins;
            }

            public Optional<List<String>> methods() {
                return baseCorsconfig.methods();
            }

            public Optional<List<String>> headers() {
                return DevUICORSFilter.this.baseCorsConfig.headers();
            }

            public Optional<List<String>> exposedHeaders() {
                return DevUICORSFilter.this.baseCorsConfig.exposedHeaders();
            }

            public Optional<Duration> accessControlMaxAge() {
                return DevUICORSFilter.this.baseCorsConfig.accessControlMaxAge();
            }

            public Optional<Boolean> accessControlAllowCredentials() {
                return DevUICORSFilter.this.baseCorsConfig.accessControlAllowCredentials();
            }
        };
    }
}

