/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.mcp.model.tool.Tool;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.quarkus.runtime.annotations.Usage;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class McpToolsService {
    @Inject
    JsonRpcRouter jsonRpcRouter;

    @JsonRpcDescription(value="This list all tools available for MCP")
    public Map<String, List<Tool>> list() {
        List<Tool> tools = this.toToolList(this.jsonRpcRouter.getRuntimeMethodsMap().values(), this.jsonRpcRouter.getDeploymentMethodsMap().values());
        return Map.of("tools", tools);
    }

    private List<Tool> toToolList(Collection<JsonRpcMethod> runtimeMethods, Collection<JsonRpcMethod> deploymentMethods) {
        ArrayList<Tool> tools = new ArrayList<Tool>();
        for (JsonRpcMethod runtimeJsonRpcMethod : runtimeMethods) {
            this.addTool(tools, runtimeJsonRpcMethod);
        }
        for (JsonRpcMethod deploymentJsonRpcMethod : deploymentMethods) {
            this.addTool(tools, deploymentJsonRpcMethod);
        }
        return tools;
    }

    private void addTool(List<Tool> tools, JsonRpcMethod method) {
        Tool tool = this.toTool(method);
        if (tool != null) {
            tools.add(tool);
        }
    }

    private Tool toTool(JsonRpcMethod jsonRpcMethod) {
        if (!jsonRpcMethod.getUsage().contains(Usage.DEV_MCP)) {
            return null;
        }
        Tool tool = new Tool();
        tool.name = jsonRpcMethod.getMethodName();
        if (jsonRpcMethod.getDescription() != null && !jsonRpcMethod.getDescription().isBlank()) {
            tool.description = jsonRpcMethod.getDescription();
        }
        LinkedHashMap props = new LinkedHashMap();
        ArrayList<String> required = new ArrayList<String>();
        if (jsonRpcMethod.hasParameters()) {
            for (Map.Entry<String, JsonRpcMethod.Parameter> parameter : jsonRpcMethod.getParameters().entrySet()) {
                HashMap<String, String> prop = new HashMap<String, String>();
                JsonRpcMethod.Parameter p = parameter.getValue();
                prop.put("type", this.mapJavaTypeToJsonType(p.getType()));
                if (p.getDescription() != null && !p.getDescription().isBlank()) {
                    prop.put("description", p.getDescription());
                }
                required.add(parameter.getKey());
                props.put(parameter.getKey(), prop);
            }
        }
        tool.inputSchema = Map.of("type", "object", "properties", props, "required", required);
        return tool;
    }

    private String mapJavaTypeToJsonType(Class<?> clazz) {
        if (clazz == null) {
            return "string";
        }
        if (clazz == String.class) {
            return "string";
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return "boolean";
        }
        if (clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Byte.class || clazz == Byte.TYPE) {
            return "integer";
        }
        if (clazz == Double.class || clazz == Double.TYPE || clazz == Float.class || clazz == Float.TYPE) {
            return "number";
        }
        if (clazz.isArray() || List.class.isAssignableFrom(clazz)) {
            return "array";
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return "object";
        }
        return "string";
    }
}

