/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.tests;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.test.config.TestConfigProviderResolver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.jboss.logging.Logger;

public abstract class DevUIBuildTimeDataTest {
    protected static final Logger log = Logger.getLogger(DevUIBuildTimeDataTest.class);
    protected URI uri;
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFactory factory = this.mapper.getFactory();
    private static final String DOT = ".";
    private static final String CONST = "export const ";
    private static final String SPACE = " ";
    private static final String EQUALS = "=";

    public DevUIBuildTimeDataTest(String namespace) {
        if (namespace.contains(DOT)) {
            namespace = namespace.substring(namespace.lastIndexOf(DOT) + 1);
        }
        Config config = ((TestConfigProviderResolver)ConfigProviderResolver.instance()).getConfig(LaunchMode.DEVELOPMENT);
        String testUrl = (String)config.getValue("test.url", String.class);
        Object nonApplicationRoot = config.getOptionalValue("quarkus.http.non-application-root-path", String.class).orElse("q");
        if (!((String)nonApplicationRoot).startsWith("/")) {
            nonApplicationRoot = "/" + (String)nonApplicationRoot;
        }
        this.uri = URI.create(testUrl + (String)nonApplicationRoot + "/dev-ui/" + namespace + "-data.js");
    }

    public List<String> getAllKeys() throws IOException {
        String data = this.readDataFromUrl();
        String[] kvs = data.split(CONST);
        ArrayList<String> l = new ArrayList<String>();
        for (String kv : kvs) {
            String k = kv.split(EQUALS)[0];
            if (k.startsWith("// Generated") || k.isBlank()) continue;
            l.add(k.trim());
        }
        return l;
    }

    public JsonNode getBuildTimeData(String key) throws Exception {
        String[] kvs;
        String data = this.readDataFromUrl();
        for (String kv : kvs = data.split(CONST)) {
            if (!kv.startsWith(key + " = ")) continue;
            String json = kv.substring(kv.indexOf(EQUALS) + 1).trim();
            log.debug((Object)("json = " + json));
            return this.toJsonNode(json);
        }
        return null;
    }

    protected JsonNode toJsonNode(String json) {
        try {
            JsonParser parser = this.factory.createParser(json);
            return (JsonNode)this.mapper.readTree(parser);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String readDataFromUrl() throws MalformedURLException, IOException {
        try (Scanner scanner = new Scanner(this.uri.toURL().openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : null;
            return string;
        }
    }
}

