/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestRunResults;
import java.util.HashMap;
import java.util.Map;

public class TrimmedTestRunResult {
    private final long id;
    private final boolean full;
    private final long started;
    private final long completed;
    private final Map<String, TestClassResult> currentFailing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> historicFailing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> currentPassing = new HashMap<String, TestClassResult>();
    private final Map<String, TestClassResult> historicPassing = new HashMap<String, TestClassResult>();
    private final long passedCount;
    private final long failedCount;
    private final long skippedCount;
    private final long currentPassedCount;
    private final long currentFailedCount;
    private final long currentSkippedCount;

    public TrimmedTestRunResult(TestRunResults testRunResults) {
        this.id = testRunResults.getId();
        this.full = testRunResults.isFull();
        this.started = testRunResults.getStartedTime();
        this.completed = testRunResults.getCompletedTime();
        this.currentFailing.putAll(testRunResults.getCurrentFailing());
        this.historicFailing.putAll(testRunResults.getHistoricFailing());
        this.currentPassing.putAll(testRunResults.getCurrentPassing());
        this.historicPassing.putAll(testRunResults.getHistoricPassing());
        this.passedCount = testRunResults.getPassedCount();
        this.failedCount = testRunResults.getFailedCount();
        this.skippedCount = testRunResults.getSkippedCount();
        this.currentPassedCount = testRunResults.getCurrentPassedCount();
        this.currentFailedCount = testRunResults.getCurrentFailedCount();
        this.currentSkippedCount = testRunResults.getCurrentSkippedCount();
    }

    public long getId() {
        return this.id;
    }

    public boolean isFull() {
        return this.full;
    }

    public Map<String, TestClassResult> getCurrentFailing() {
        return this.currentFailing;
    }

    public Map<String, TestClassResult> getHistoricFailing() {
        return this.historicFailing;
    }

    public Map<String, TestClassResult> getCurrentPassing() {
        return this.currentPassing;
    }

    public Map<String, TestClassResult> getHistoricPassing() {
        return this.historicPassing;
    }

    public long getStartedTime() {
        return this.started;
    }

    public long getCompletedTime() {
        return this.completed;
    }

    public long getTotalTime() {
        return this.completed - this.started;
    }

    public long getPassedCount() {
        return this.passedCount;
    }

    public long getFailedCount() {
        return this.failedCount;
    }

    public long getSkippedCount() {
        return this.skippedCount;
    }

    public long getCurrentPassedCount() {
        return this.currentPassedCount;
    }

    public long getCurrentFailedCount() {
        return this.currentFailedCount;
    }

    public long getCurrentSkippedCount() {
        return this.currentSkippedCount;
    }
}

