/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.BuildTimeConstBuildItem;
import io.quarkus.devui.deployment.DeploymentMethodBuildItem;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.DevUIRoutesBuildItem;
import io.quarkus.devui.deployment.DevUIWebJarBuildItem;
import io.quarkus.devui.deployment.ExtensionsBuildItem;
import io.quarkus.devui.deployment.JsonRPCRuntimeMethodsBuildItem;
import io.quarkus.devui.deployment.MvnpmBuildItem;
import io.quarkus.devui.deployment.extension.Codestart;
import io.quarkus.devui.deployment.extension.Extension;
import io.quarkus.devui.deployment.jsonrpc.DevUIDatabindCodec;
import io.quarkus.devui.runtime.DevUIRecorder;
import io.quarkus.devui.runtime.VertxRouteInfoService;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.spi.DevUIContent;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.buildtime.FooterLogBuildItem;
import io.quarkus.devui.spi.buildtime.StaticContentBuildItem;
import io.quarkus.devui.spi.page.Card;
import io.quarkus.devui.spi.page.CardPageBuildItem;
import io.quarkus.devui.spi.page.FooterPageBuildItem;
import io.quarkus.devui.spi.page.LibraryLink;
import io.quarkus.devui.spi.page.MenuPageBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.QuteDataPageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.maven.dependency.GACTV;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.qute.Qute;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.common.annotation.Blocking;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.vertx.core.Handler;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.JandexReflection;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class DevUIProcessor {
    private static final String FOOTER_LOG_NAMESPACE = "devui-footer-log";
    private static final String DEVUI = "dev-ui";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String SLASH_ALL = "/*";
    private static final String JSONRPC = "json-rpc-ws";
    private static final String CONSTRUCTOR = "<init>";
    private final ClassLoader tccl = Thread.currentThread().getContextClassLoader();
    private static final String JAR = "jar";
    private static final GACT UI_JAR = new GACT("io.quarkus", "quarkus-devui-resources", null, "jar");
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String ARTIFACT = "artifact";
    private static final String METADATA = "metadata";
    private static final String KEYWORDS = "keywords";
    private static final String SHORT_NAME = "short-name";
    private static final String GUIDE = "guide";
    private static final String CATEGORIES = "categories";
    private static final String STATUS = "status";
    private static final String BUILT_WITH = "built-with-quarkus-core";
    private static final String CONFIG = "config";
    private static final String EXTENSION_DEPENDENCIES = "extension-dependencies";
    private static final String CAPABILITIES = "capabilities";
    private static final String PROVIDES = "provides";
    private static final String UNLISTED = "unlisted";
    private static final String HIDE = "hide-in-dev-ui";
    private static final String CODESTART = "codestart";
    private static final String LANGUAGES = "languages";
    private static final String ICON_URL = "icon-url";
    private static final String LIB_GA = "lib-ga";
    private final Pattern libGAPattern = Pattern.compile("([^:\\[\\]]+):([^\\[\\]]+)(\\[(.+?)\\])?");
    private static final Logger log = Logger.getLogger(DevUIProcessor.class);
    private final Comparator sortingComparator = new Comparator<Extension>(){

        @Override
        public int compare(Extension t, Extension t1) {
            if (t.getGuide() != null && t1.getGuide() != null) {
                return t.getName().compareTo(t1.getName());
            }
            if (t.getGuide() == null) {
                return 1;
            }
            return -1;
        }
    };

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerDevUiHandlers(DevUIConfig devUIConfig, MvnpmBuildItem mvnpmBuildItem, List<DevUIRoutesBuildItem> devUIRoutesBuildItems, List<StaticContentBuildItem> staticContentBuildItems, BuildProducer<RouteBuildItem> routeProducer, DevUIRecorder recorder, LaunchModeBuildItem launchModeBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, ShutdownContextBuildItem shutdownContext) throws IOException {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().orderedRoute("dev-ui/*", Integer.valueOf(-600)).handler(recorder.createLocalHostOnlyFilter((List)devUIConfig.hosts().orElse(null))).build());
        if (devUIConfig.cors().enabled()) {
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().orderedRoute("dev-ui/*", Integer.valueOf(-300)).handler(recorder.createDevUICorsFilter((List)devUIConfig.hosts().orElse(null))).build());
        }
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/json-rpc-ws").handler(recorder.communicationHandler()).build());
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            String route = devUIRoutesBuildItem.getPath();
            String string = nonApplicationRootPathBuildItem.resolvePath(route);
            Handler uihandler = recorder.uiHandler(devUIRoutesBuildItem.getFinalDestination(), string, devUIRoutesBuildItem.getWebRootConfigurations(), (ShutdownContext)shutdownContext);
            NonApplicationRootPathBuildItem.Builder builder = nonApplicationRootPathBuildItem.routeBuilder().route(route).handler(uihandler);
            if (route.endsWith("dev-ui/")) {
                builder = builder.displayOnNotFoundPage("Dev UI");
                routeProducer.produce((BuildItem)builder.build());
            }
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route((String)route + SLASH_ALL).handler(uihandler).build());
        }
        String basepath = nonApplicationRootPathBuildItem.resolvePath(DEVUI);
        Path devUiBasePath = Files.createTempDirectory("quarkus-devui", new FileAttribute[0]);
        recorder.shutdownTask((ShutdownContext)shutdownContext, devUiBasePath.toString());
        for (StaticContentBuildItem staticContentBuildItem : staticContentBuildItems) {
            HashMap<String, String> urlAndPath = new HashMap<String, String>();
            List content = staticContentBuildItem.getContent();
            for (DevUIContent c : content) {
                String parsedContent = Qute.fmt((String)new String(c.getTemplate()), (Map)c.getData());
                Path tempFile = devUiBasePath.resolve(c.getFileName());
                Files.writeString(tempFile, (CharSequence)parsedContent, new OpenOption[0]);
                urlAndPath.put(c.getFileName(), tempFile.toString());
            }
            Handler buildTimeStaticHandler = recorder.buildTimeStaticHandler(basepath, urlAndPath);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/*").handler(buildTimeStaticHandler).build());
        }
        Handler endpointInfoHandler = recorder.endpointInfoHandler(basepath);
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("dev-ui/endpoints/*").handler(endpointInfoHandler).build());
        for (DevUIRoutesBuildItem devUIRoutesBuildItem : devUIRoutesBuildItems) {
            String route = devUIRoutesBuildItem.getPath();
            basepath = nonApplicationRootPathBuildItem.resolvePath(route);
            Handler routerhandler = recorder.vaadinRouterHandler(basepath);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(route + SLASH_ALL).handler(routerhandler).build());
        }
        String string = nonApplicationRootPathBuildItem.getNonApplicationRootPath();
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("_static/*").handler(recorder.mvnpmHandler(string, mvnpmBuildItem.getMvnpmJars())).build());
        routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("dev").handler(recorder.redirect(string)).build());
        if (!this.hasOwnIndexHtml()) {
            routeProducer.produce((BuildItem)httpRootPathBuildItem.routeBuilder().orderedRoute(SLASH, Integer.valueOf(Integer.MAX_VALUE)).handler(recorder.redirect(string, "welcome")).build());
        }
    }

    private boolean hasOwnIndexHtml() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> jarsWithIndexHtml = tccl.getResources("META-INF/resources/index.html");
            return jarsWithIndexHtml.hasMoreElements();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void additionalBean(BuildProducer<AdditionalBeanBuildItem> additionalBeanProducer, BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexProducer, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems) {
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonRpcRouter.class).addBeanClass(VertxRouteInfoService.class).setUnremovable().build());
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class c = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            additionalIndexProducer.produce((BuildItem)new AdditionalIndexedClassesBuildItem(c.getName()));
            DotName defaultBeanScope = jsonRPCProvidersBuildItem.getDefaultBeanScope() == null ? BuiltinScope.APPLICATION.getName() : jsonRPCProvidersBuildItem.getDefaultBeanScope();
            additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(c).setDefaultScope(defaultBeanScope).setUnremovable().build());
        }
        additionalBeanProducer.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClass(JsonRpcRouter.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void findAllJsonRPCMethods(BuildProducer<JsonRPCRuntimeMethodsBuildItem> jsonRPCMethodsProvider, BuildProducer<BuildTimeConstBuildItem> buildTimeConstProducer, LaunchModeBuildItem launchModeBuildItem, CombinedIndexBuildItem combinedIndexBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, List<JsonRPCProvidersBuildItem> jsonRPCProvidersBuildItems, DeploymentMethodBuildItem deploymentMethodBuildItem) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        IndexView index = combinedIndexBuildItem.getIndex();
        HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = new HashMap<String, Map<JsonRpcMethodName, JsonRpcMethod>>();
        ArrayList<Object> requestResponseMethods = new ArrayList<Object>();
        ArrayList<Object> subscriptionMethods = new ArrayList<Object>();
        for (JsonRPCProvidersBuildItem jsonRPCProvidersBuildItem : jsonRPCProvidersBuildItems) {
            Class clazz = jsonRPCProvidersBuildItem.getJsonRPCMethodProviderClass();
            String extension = jsonRPCProvidersBuildItem.getExtensionPathName(curateOutcomeBuildItem);
            Map<JsonRpcMethodName, JsonRpcMethod> jsonRpcMethods = new HashMap();
            if (extensionMethodsMap.containsKey(extension)) {
                jsonRpcMethods = (Map)extensionMethodsMap.get(extension);
            }
            ClassInfo classInfo = index.getClassByName(DotName.createSimple((String)clazz.getName()));
            List methods = classInfo.methods();
            for (MethodInfo method : methods) {
                if (method.name().equals(CONSTRUCTOR) || !Modifier.isPublic(method.flags()) || method.returnType().kind() == Type.Kind.VOID) continue;
                if (method.returnType().name().equals((Object)DotName.createSimple((String)Multi.class.getName()))) {
                    subscriptionMethods.add(extension + DOT + method.name());
                } else {
                    requestResponseMethods.add(extension + DOT + method.name());
                }
                JsonRpcMethodName jsonRpcMethodName = new JsonRpcMethodName(method.name());
                if (method.parametersCount() > 0) {
                    LinkedHashMap<String, Class> params = new LinkedHashMap<String, Class>();
                    for (int i = 0; i < method.parametersCount(); ++i) {
                        Type parameterType = method.parameterType(i);
                        Class parameterClass = this.toClass(parameterType);
                        String parameterName = method.parameterName(i);
                        params.put(parameterName, parameterClass);
                    }
                    JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), params);
                    jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                    jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                    jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
                    continue;
                }
                JsonRpcMethod jsonRpcMethod = new JsonRpcMethod(clazz, method.name(), null);
                jsonRpcMethod.setExplicitlyBlocking(method.hasAnnotation(Blocking.class));
                jsonRpcMethod.setExplicitlyNonBlocking(method.hasAnnotation(NonBlocking.class));
                jsonRpcMethods.put(jsonRpcMethodName, jsonRpcMethod);
            }
            if (jsonRpcMethods.isEmpty()) continue;
            extensionMethodsMap.put(extension, jsonRpcMethods);
        }
        if (deploymentMethodBuildItem.hasMethods()) {
            requestResponseMethods.addAll(deploymentMethodBuildItem.getMethods());
        }
        if (deploymentMethodBuildItem.hasSubscriptions()) {
            subscriptionMethods.addAll(deploymentMethodBuildItem.getSubscriptions());
        }
        if (!extensionMethodsMap.isEmpty()) {
            jsonRPCMethodsProvider.produce((BuildItem)new JsonRPCRuntimeMethodsBuildItem(extensionMethodsMap));
        }
        BuildTimeConstBuildItem methodInfo = new BuildTimeConstBuildItem("devui-jsonrpc");
        if (!subscriptionMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCSubscriptions", subscriptionMethods);
        }
        if (!requestResponseMethods.isEmpty()) {
            methodInfo.addBuildTimeData("jsonRPCMethods", requestResponseMethods);
        }
        buildTimeConstProducer.produce((BuildItem)methodInfo);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void createJsonRpcRouter(DevUIRecorder recorder, BeanContainerBuildItem beanContainer, JsonRPCRuntimeMethodsBuildItem jsonRPCMethodsBuildItem, DeploymentMethodBuildItem deploymentMethodBuildItem) {
        if (jsonRPCMethodsBuildItem != null) {
            Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap = jsonRPCMethodsBuildItem.getExtensionMethodsMap();
            DevConsoleManager.setGlobal((String)"dev-ui-databind-codec-builder", (Object)JsonMapper.Factory.deploymentLinker().createLinkData((Object)new DevUIDatabindCodec.Factory()));
            recorder.createJsonRpcRouter(beanContainer.getValue(), extensionMethodsMap, deploymentMethodBuildItem.getMethods(), deploymentMethodBuildItem.getSubscriptions(), deploymentMethodBuildItem.getRecordedValues());
        }
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void processFooterLogs(BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, BuildProducer<FooterPageBuildItem> footerPageProducer, List<FooterLogBuildItem> footerLogBuildItems) {
        ArrayList<BuildTimeActionBuildItem> devServiceLogs = new ArrayList<BuildTimeActionBuildItem>();
        ArrayList<FooterPageBuildItem> footers = new ArrayList<FooterPageBuildItem>();
        for (FooterLogBuildItem footerLogBuildItem : footerLogBuildItems) {
            String name = footerLogBuildItem.getName().replaceAll(" ", "");
            BuildTimeActionBuildItem devServiceLogActions = new BuildTimeActionBuildItem(FOOTER_LOG_NAMESPACE);
            if (footerLogBuildItem.hasRuntimePublisher()) {
                devServiceLogActions.addSubscription(name + "Log", footerLogBuildItem.getRuntimePublisher());
            } else {
                devServiceLogActions.addSubscription(name + "Log", ignored -> {
                    try {
                        return footerLogBuildItem.getPublisher();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            devServiceLogs.add(devServiceLogActions);
            WebComponentPageBuilder log = ((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace(FOOTER_LOG_NAMESPACE)).icon("font-awesome-regular:file-lines")).title(this.capitalizeFirstLetter(footerLogBuildItem.getName()))).metadata("jsonRpcMethodName", footerLogBuildItem.getName() + "Log")).componentLink("qwc-footer-log.js");
            FooterPageBuildItem footerPageBuildItem = new FooterPageBuildItem(FOOTER_LOG_NAMESPACE, new PageBuilder[]{log});
            footers.add(footerPageBuildItem);
        }
        buildTimeActionProducer.produce(devServiceLogs);
        footerPageProducer.produce(footers);
    }

    private String capitalizeFirstLetter(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void getAllExtensions(List<CardPageBuildItem> cardPageBuildItems, List<MenuPageBuildItem> menuPageBuildItems, List<FooterPageBuildItem> footerPageBuildItems, LaunchModeBuildItem launchModeBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ExtensionsBuildItem> extensionsProducer, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer, Capabilities capabilities) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            ExtensionsBuildItem emptyExtensionBuildItem = new ExtensionsBuildItem(List.of(), List.of(), List.of(), List.of());
            extensionsProducer.produce((BuildItem)emptyExtensionBuildItem);
            return;
        }
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(UI_JAR).root("dev-ui/").build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(UI_JAR, DEVUI));
        boolean assistantIsAvailable = capabilities.isPresent("io.quarkus.assistant");
        Map<String, CardPageBuildItem> cardPagesMap = this.getCardPagesMap(curateOutcomeBuildItem, cardPageBuildItems);
        Map<String, MenuPageBuildItem> menuPagesMap = this.getMenuPagesMap(curateOutcomeBuildItem, menuPageBuildItems);
        Map<String, List<FooterPageBuildItem>> footerPagesMap = this.getFooterPagesMap(curateOutcomeBuildItem, footerPageBuildItems);
        Yaml yaml = new Yaml();
        ArrayList<Extension> activeExtensions = new ArrayList<Extension>();
        ArrayList<Extension> inactiveExtensions = new ArrayList<Extension>();
        ArrayList<Extension> sectionMenuExtensions = new ArrayList<Extension>();
        ArrayList<Extension> footerTabExtensions = new ArrayList<Extension>();
        for (ResolvedDependency resolvedDependency : curateOutcomeBuildItem.getApplicationModel().getDependencies(16)) {
            resolvedDependency.getContentTree().accept("META-INF/quarkus-extension.yaml", extYamlVisit -> {
                block26: {
                    if (extYamlVisit == null) {
                        log.error((Object)("Failed to locate META-INF/quarkus-extension.yaml in " + runtimeExt.toCompactCoords()));
                        return;
                    }
                    Path extYaml = extYamlVisit.getPath();
                    try {
                        boolean isHidden;
                        String extensionYaml;
                        Extension extension = new Extension();
                        try (Scanner scanner = new Scanner(Files.newBufferedReader(extYaml, StandardCharsets.UTF_8));){
                            scanner.useDelimiter("\\A");
                            extensionYaml = scanner.hasNext() ? scanner.next() : null;
                        }
                        if (extensionYaml == null) {
                            return;
                        }
                        Map extensionMap = (Map)yaml.load(extensionYaml);
                        if (!extensionMap.containsKey(NAME)) break block26;
                        Map metaData = extensionMap.getOrDefault(METADATA, null);
                        if (metaData != null && !(isHidden = Boolean.valueOf(String.valueOf(metaData.getOrDefault(HIDE, false))).booleanValue())) {
                            Page page;
                            Map buildTimeData;
                            Map codestartMap;
                            String namespace = this.getExtensionNamespace(extensionMap);
                            extension.setNamespace(namespace);
                            extension.setName((String)extensionMap.get(NAME));
                            extension.setDescription(extensionMap.getOrDefault(DESCRIPTION, null));
                            extension.setArtifact(extensionMap.getOrDefault(ARTIFACT, null));
                            extension.setKeywords(metaData.getOrDefault(KEYWORDS, null));
                            extension.setShortName(metaData.getOrDefault(SHORT_NAME, null));
                            if (metaData.containsKey(GUIDE)) {
                                String guide = (String)metaData.get(GUIDE);
                                try {
                                    extension.setGuide(new URL(guide));
                                }
                                catch (MalformedURLException mue) {
                                    log.warn((Object)("Could not set Guide URL [" + guide + "] for exception [" + namespace + "]"));
                                }
                            }
                            extension.setCategories(metaData.getOrDefault(CATEGORIES, null));
                            extension.setStatus(this.collectionToString(metaData, STATUS));
                            extension.setBuiltWith(metaData.getOrDefault(BUILT_WITH, null));
                            extension.setConfigFilter(metaData.getOrDefault(CONFIG, null));
                            extension.setExtensionDependencies(metaData.getOrDefault(EXTENSION_DEPENDENCIES, null));
                            extension.setUnlisted(String.valueOf(metaData.getOrDefault(UNLISTED, false)));
                            if (metaData.containsKey(CAPABILITIES)) {
                                Map cap = (Map)metaData.get(CAPABILITIES);
                                extension.setProvidesCapabilities(cap.getOrDefault(PROVIDES, null));
                            }
                            if (metaData.containsKey(CODESTART) && (codestartMap = (Map)metaData.get(CODESTART)) != null) {
                                Codestart codestart = new Codestart();
                                codestart.setName(codestartMap.getOrDefault(NAME, null));
                                codestart.setLanguages(this.listOrString(codestartMap, LANGUAGES));
                                codestart.setArtifact(codestartMap.getOrDefault(ARTIFACT, null));
                                extension.setCodestart(codestart);
                            }
                            if (cardPagesMap.containsKey(namespace) && ((CardPageBuildItem)cardPagesMap.get(namespace)).hasPages()) {
                                CardPageBuildItem cardPageBuildItem = (CardPageBuildItem)cardPagesMap.get(namespace);
                                List cardPageBuilders = cardPageBuildItem.getPages();
                                buildTimeData = cardPageBuildItem.getBuildTimeData();
                                for (PageBuilder pageBuilder : cardPageBuilders) {
                                    page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                    if (page.isAssistantPage() && !assistantIsAvailable) continue;
                                    extension.addCardPage(page);
                                }
                                cardPageBuildItem.getOptionalCard().ifPresent(card -> {
                                    card.setNamespace(extension.getNamespace());
                                    extension.setCard((Card)card);
                                });
                                String headlessJs = cardPageBuildItem.getHeadlessComponentLink();
                                if (headlessJs != null) {
                                    extension.setHeadlessComponent(headlessJs);
                                }
                                this.addLogo(extension, cardPageBuildItem, metaData);
                                this.addLibraryLinks(extension, cardPageBuildItem, curateOutcomeBuildItem, metaData);
                                this.produceResources(runtimeExt, webJarBuildProducer, devUIWebJarProducer);
                                activeExtensions.add(extension);
                            } else {
                                if (this.addLogo(extension, (CardPageBuildItem)cardPagesMap.get(namespace), metaData)) {
                                    this.produceResources(runtimeExt, webJarBuildProducer, devUIWebJarProducer);
                                }
                                this.addLibraryLinks(extension, (CardPageBuildItem)cardPagesMap.get(namespace), curateOutcomeBuildItem, metaData);
                                inactiveExtensions.add(extension);
                            }
                            if (menuPagesMap.containsKey(namespace)) {
                                MenuPageBuildItem menuPageBuildItem = (MenuPageBuildItem)menuPagesMap.get(namespace);
                                List menuPageBuilders = menuPageBuildItem.getPages();
                                buildTimeData = menuPageBuildItem.getBuildTimeData();
                                for (PageBuilder pageBuilder : menuPageBuilders) {
                                    page = this.buildFinalPage(pageBuilder, extension, buildTimeData);
                                    if (page.isAssistantPage() && !assistantIsAvailable) continue;
                                    extension.addMenuPage(page);
                                }
                                this.produceResources(runtimeExt, webJarBuildProducer, devUIWebJarProducer);
                                sectionMenuExtensions.add(extension);
                            }
                            if (footerPagesMap.containsKey(namespace)) {
                                List fbis = (List)footerPagesMap.get(namespace);
                                for (FooterPageBuildItem footerPageBuildItem : fbis) {
                                    List footerPageBuilders = footerPageBuildItem.getPages();
                                    Map buildTimeData2 = footerPageBuildItem.getBuildTimeData();
                                    for (PageBuilder pageBuilder : footerPageBuilders) {
                                        Page page2 = this.buildFinalPage(pageBuilder, extension, buildTimeData2);
                                        if (page2.isAssistantPage() && !assistantIsAvailable) continue;
                                        extension.addFooterPage(page2);
                                    }
                                    this.produceResources(runtimeExt, webJarBuildProducer, devUIWebJarProducer);
                                    footerTabExtensions.add(extension);
                                }
                            }
                        }
                        Collections.sort(activeExtensions, this.sortingComparator);
                        Collections.sort(inactiveExtensions, this.sortingComparator);
                    }
                    catch (IOException | RuntimeException e) {
                        log.error((Object)("Failed to process extension descriptor " + String.valueOf(extYaml.toUri())), (Throwable)e);
                    }
                }
            });
        }
        if (!footerPagesMap.isEmpty()) {
            for (Map.Entry entry : footerPagesMap.entrySet()) {
                List fbis = (List)entry.getValue();
                for (FooterPageBuildItem footerPageBuildItem : fbis) {
                    if (!footerPageBuildItem.isInternal()) continue;
                    Extension deploymentOnlyExtension = new Extension();
                    deploymentOnlyExtension.setName((String)entry.getKey());
                    deploymentOnlyExtension.setNamespace(FOOTER_LOG_NAMESPACE);
                    List footerPageBuilders = footerPageBuildItem.getPages();
                    for (PageBuilder pageBuilder : footerPageBuilders) {
                        pageBuilder.namespace(deploymentOnlyExtension.getNamespace());
                        pageBuilder.extension(deploymentOnlyExtension.getName());
                        pageBuilder.internal();
                        Page page = pageBuilder.build();
                        deploymentOnlyExtension.addFooterPage(page);
                    }
                    footerTabExtensions.add(deploymentOnlyExtension);
                }
            }
        }
        extensionsProducer.produce((BuildItem)new ExtensionsBuildItem(activeExtensions, inactiveExtensions, sectionMenuExtensions, footerTabExtensions));
    }

    private void addLibraryLinks(Extension extension, CardPageBuildItem cardPageBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, Map<String, Object> metaData) {
        String libGA;
        Matcher matcher;
        if (cardPageBuildItem != null && !cardPageBuildItem.hasLibraryVersions() && !metaData.containsKey(LIB_GA)) {
            return;
        }
        Map<String, String> versionMap = curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().collect(Collectors.toMap(rd -> rd.getGroupId() + ":" + rd.getArtifactId(), ArtifactCoords::getVersion, (existing, replacement) -> existing));
        if (cardPageBuildItem != null) {
            for (LibraryLink lib : cardPageBuildItem.getLibraryVersions()) {
                String key = lib.getGroupId() + ":" + lib.getArtifactId();
                String version = versionMap.get(key);
                if (version == null) continue;
                lib.setVersion(version);
                extension.addLibraryLink(lib);
            }
        }
        if (metaData.containsKey(LIB_GA) && !extension.hasLibraryLinks() && (matcher = this.libGAPattern.matcher(libGA = (String)metaData.get(LIB_GA))).matches()) {
            String version;
            String groupId = matcher.group(1);
            String artifactId = matcher.group(2);
            URL url = null;
            if (matcher.group(4) != null) {
                try {
                    url = URI.create(matcher.group(4)).toURL();
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
            if ((version = versionMap.get(groupId + ":" + artifactId)) != null) {
                LibraryLink l = new LibraryLink(groupId, artifactId, artifactId, url);
                l.setVersion(version);
                extension.addLibraryLink(l);
            }
        }
    }

    private boolean addLogo(Extension extension, CardPageBuildItem cardPageBuildItem, Map<String, Object> metaData) {
        if (cardPageBuildItem != null && cardPageBuildItem.hasLogo()) {
            extension.setLogo(cardPageBuildItem.getDarkLogo(), cardPageBuildItem.getLightLogo());
            return true;
        }
        if (metaData.containsKey(ICON_URL)) {
            String iconUrl = (String)metaData.get(ICON_URL);
            extension.setLogo(iconUrl, iconUrl);
            return true;
        }
        return false;
    }

    private String collectionToString(Map<String, Object> metaData, String key) {
        Object value = metaData.getOrDefault(key, null);
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return (String)value;
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            List values = (List)value;
            return values.stream().map(n -> String.valueOf(n)).collect(Collectors.joining(", "));
        }
        return String.valueOf(value);
    }

    private List<String> listOrString(Map<String, Object> metaData, String key) {
        Object value = metaData.getOrDefault(key, null);
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            return List.of((String)value);
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            return (List)value;
        }
        return List.of(String.valueOf(value));
    }

    private void produceResources(ResolvedDependency runtimeExt, BuildProducer<WebJarBuildItem> webJarBuildProducer, BuildProducer<DevUIWebJarBuildItem> devUIWebJarProducer) {
        String namespace = this.getNamespace(runtimeExt.getKey());
        if (namespace.isEmpty()) {
            namespace = "devui";
        }
        final String buildTimeDataImport = namespace + "-data";
        GACT deploymentKey = DevUIProcessor.getDeploymentKey(runtimeExt);
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(deploymentKey).root("dev-ui/").filter(new WebJarResourcesFilter(){

            public WebJarResourcesFilter.FilterResult apply(String fileName, InputStream file) throws IOException {
                if (fileName.endsWith(".js")) {
                    String content = new String(file.readAllBytes(), StandardCharsets.UTF_8);
                    content = content.replaceAll("build-time-data", buildTimeDataImport);
                    return new WebJarResourcesFilter.FilterResult((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), true);
                }
                return new WebJarResourcesFilter.FilterResult(file, false);
            }
        }).build());
        devUIWebJarProducer.produce((BuildItem)new DevUIWebJarBuildItem(deploymentKey, DEVUI));
    }

    private static GACT getDeploymentKey(ResolvedDependency runtimeExt) {
        return (GACT)runtimeExt.getContentTree().apply("META-INF/quarkus-extension.properties", extPropsVisit -> {
            if (extPropsVisit == null) {
                throw new RuntimeException("Failed to locate META-INF/quarkus-extension.properties in " + runtimeExt.toCompactCoords());
            }
            Properties props = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(extPropsVisit.getPath());){
                props.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read " + String.valueOf(extPropsVisit.getUrl()), e);
            }
            String deploymentCoords = props.getProperty("deployment-artifact");
            if (deploymentCoords == null) {
                throw new RuntimeException("Failed to locate deployment-artifact in " + String.valueOf(extPropsVisit.getUrl()));
            }
            GACTV coords = GACTV.fromString((String)deploymentCoords);
            return new GACT(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType());
        });
    }

    @BuildStep(onlyIf={IsLocalDevelopment.class})
    void createAllRoutes(WebJarResultsBuildItem webJarResultsBuildItem, LaunchModeBuildItem launchModeBuildItem, List<DevUIWebJarBuildItem> devUIWebJarBuiltItems, BuildProducer<DevUIRoutesBuildItem> devUIRoutesProducer) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        for (DevUIWebJarBuildItem devUIWebJarBuiltItem : devUIWebJarBuiltItems) {
            WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(devUIWebJarBuiltItem.getArtifactKey());
            if (result == null) continue;
            String namespace = this.getNamespace((ArtifactKey)devUIWebJarBuiltItem.getArtifactKey());
            devUIRoutesProducer.produce((BuildItem)new DevUIRoutesBuildItem(namespace, devUIWebJarBuiltItem.getPath(), result.getFinalDestination(), result.getWebRootConfigurations()));
        }
    }

    private String getNamespace(ArtifactKey artifactKey) {
        Object namespace = artifactKey.getGroupId() + DOT + artifactKey.getArtifactId();
        if (((String)namespace).equals("io.quarkus.quarkus-devui-resources")) {
            namespace = "";
        } else if (((String)namespace).endsWith("-deployment")) {
            int end = ((String)namespace).lastIndexOf("-");
            namespace = ((String)namespace).substring(0, end);
        }
        return namespace;
    }

    private Page buildFinalPage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        pageBuilder.namespace(extension.getNamespace());
        pageBuilder.extension(extension.getName());
        if (pageBuilder.getClass().equals(QuteDataPageBuilder.class)) {
            return this.buildQutePage(pageBuilder, extension, buildTimeData);
        }
        return pageBuilder.build();
    }

    private Page buildQutePage(PageBuilder pageBuilder, Extension extension, Map<String, Object> buildTimeData) {
        try {
            QuteDataPageBuilder quteDataPageBuilder = (QuteDataPageBuilder)pageBuilder;
            String templatePath = quteDataPageBuilder.getTemplatePath();
            ClassPathUtils.consumeAsPaths((String)templatePath, p -> {
                try {
                    String template = Files.readString(p);
                    String fragment = Qute.fmt((String)template, (Map)buildTimeData);
                    pageBuilder.metadata("htmlFragment", fragment);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return pageBuilder.build();
    }

    private Class toClass(Type type) {
        if (type.kind().equals((Object)Type.Kind.PRIMITIVE)) {
            return JandexReflection.loadRawType((Type)type);
        }
        if (type.kind().equals((Object)Type.Kind.VOID)) {
            throw new RuntimeException("Void method return detected, JsonRPC Method needs to return something.");
        }
        try {
            return this.tccl.loadClass(type.name().toString());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, CardPageBuildItem> getCardPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<CardPageBuildItem> pages) {
        HashMap<String, CardPageBuildItem> m = new HashMap<String, CardPageBuildItem>();
        for (CardPageBuildItem pageBuildItem : pages) {
            String name = pageBuildItem.getExtensionPathName(curateOutcomeBuildItem);
            m.put(name, pageBuildItem);
        }
        return m;
    }

    private Map<String, MenuPageBuildItem> getMenuPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<MenuPageBuildItem> pages) {
        HashMap<String, MenuPageBuildItem> m = new HashMap<String, MenuPageBuildItem>();
        for (MenuPageBuildItem pageBuildItem : pages) {
            m.put(pageBuildItem.getExtensionPathName(curateOutcomeBuildItem), pageBuildItem);
        }
        return m;
    }

    private Map<String, List<FooterPageBuildItem>> getFooterPagesMap(CurateOutcomeBuildItem curateOutcomeBuildItem, List<FooterPageBuildItem> pages) {
        HashMap<String, List<FooterPageBuildItem>> m = new HashMap<String, List<FooterPageBuildItem>>();
        for (FooterPageBuildItem pageBuildItem : pages) {
            String key = pageBuildItem.getExtensionPathName(curateOutcomeBuildItem);
            if (m.containsKey(key)) {
                ((List)m.get(key)).add(pageBuildItem);
                continue;
            }
            ArrayList<FooterPageBuildItem> fbi = new ArrayList<FooterPageBuildItem>();
            fbi.add(pageBuildItem);
            m.put(key, fbi);
        }
        return m;
    }

    private String getExtensionNamespace(Map<String, Object> extensionMap) {
        String artifactId;
        String groupId;
        String artifact = (String)extensionMap.get(ARTIFACT);
        if (artifact == null) {
            groupId = (String)extensionMap.get("group-id");
            artifactId = (String)extensionMap.get("artifact-id");
            if (artifactId == null || groupId == null) {
                throw new RuntimeException("Failed to locate 'artifact' or 'group-id' and 'artifact-id' among metadata keys " + String.valueOf(extensionMap.keySet()));
            }
        } else {
            GACTV coords = GACTV.fromString((String)artifact);
            groupId = coords.getGroupId();
            artifactId = coords.getArtifactId();
        }
        return groupId + DOT + artifactId;
    }
}

