/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.json.JsonArtifactCoordsMixin;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class RegistriesConfigMapperHelper {
    private static ObjectMapper yamlMapper;
    private static ObjectMapper jsonMapper;

    public static ObjectMapper yamlMapper() {
        return yamlMapper == null ? (yamlMapper = RegistriesConfigMapperHelper.initMapper(new ObjectMapper((JsonFactory)new YAMLFactory()))) : yamlMapper;
    }

    public static ObjectMapper jsonMapper() {
        return jsonMapper == null ? (jsonMapper = RegistriesConfigMapperHelper.initMapper(new ObjectMapper())) : jsonMapper;
    }

    private static ObjectMapper mapper(Path p) {
        return p.getFileName().toString().endsWith(".json") ? RegistriesConfigMapperHelper.jsonMapper() : RegistriesConfigMapperHelper.yamlMapper();
    }

    public static ObjectMapper initMapper(ObjectMapper mapper) {
        mapper.addMixIn(ArtifactCoords.class, JsonArtifactCoordsMixin.class).enable(SerializationFeature.INDENT_OUTPUT).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    public static void serialize(Object config, Path p) throws IOException {
        if (!Files.exists(p.getParent(), new LinkOption[0])) {
            Files.createDirectories(p.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(p, new OpenOption[0]);){
            RegistriesConfigMapperHelper.mapper(p).writeValue((Writer)writer, config);
        }
    }

    public static void toJson(Object config, Writer writer) throws IOException {
        RegistriesConfigMapperHelper.jsonMapper().writeValue(writer, config);
    }

    public static void toYaml(Object config, Writer writer) throws IOException {
        RegistriesConfigMapperHelper.yamlMapper().writeValue(writer, config);
    }

    public static <T> T deserialize(Path p, Class<T> t) throws IOException {
        if (!Files.exists(p, new LinkOption[0])) {
            throw new IllegalArgumentException("File " + p + " does not exist");
        }
        try (BufferedReader reader = Files.newBufferedReader(p);){
            Object object = RegistriesConfigMapperHelper.mapper(p).readValue((Reader)reader, t);
            return (T)object;
        }
    }

    public static <T> T deserializeYaml(InputStream is, Class<T> t) throws IOException {
        return (T)RegistriesConfigMapperHelper.yamlMapper().readValue(is, t);
    }

    public static <T> T deserializeYaml(Reader reader, Class<T> t) throws IOException {
        return (T)RegistriesConfigMapperHelper.yamlMapper().readValue(reader, t);
    }
}

