/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.catalog.PlatformStreamImpl;
import io.quarkus.registry.json.JsonBuilder;
import io.quarkus.registry.json.JsonEntityWithAnySupport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PlatformImpl
extends JsonEntityWithAnySupport
implements Platform {
    private final String platformKey;
    private final String name;
    private final Map<String, PlatformStream> streams;

    private PlatformImpl(Builder builder) {
        super(builder);
        this.platformKey = builder.platformKey;
        this.name = builder.name;
        this.streams = JsonBuilder.buildUnmodifiableMap(builder.streams, LinkedHashMap::new);
    }

    @Override
    public String getPlatformKey() {
        return this.platformKey;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @JsonSerialize(contentAs=PlatformStreamImpl.class)
    public Collection<PlatformStream> getStreams() {
        return this.streams.values();
    }

    @Override
    @JsonIgnore
    public PlatformStream getStream(String id) {
        return this.streams.get(id);
    }

    public boolean equals(Object o) {
        return PlatformImpl.platformImplEquals(this, o);
    }

    public int hashCode() {
        return Objects.hash(this.platformKey);
    }

    public String toString() {
        return PlatformImpl.platformToString(this);
    }

    static final boolean platformImplEquals(Platform p, Object o) {
        if (p == o) {
            return true;
        }
        if (!(p instanceof Platform)) {
            return false;
        }
        Platform that = (Platform)o;
        return Objects.equals(p.getPlatformKey(), that.getPlatformKey());
    }

    static final String platformToString(Platform p) {
        return p.getClass().getSimpleName() + "{platformKey='" + p.getPlatformKey() + "', name='" + p.getName() + "', streams=" + p.getStreams() + "}";
    }

    public static class Builder
    extends JsonEntityWithAnySupport.Builder
    implements Platform.Mutable {
        private String platformKey;
        private String name;
        private Map<String, PlatformStream> streams;

        public Builder() {
        }

        public Builder(Platform source) {
            this.platformKey = source.getPlatformKey();
            this.name = source.getName();
            this.setStreams((Collection)source.getStreams());
            this.setMetadata((Map)source.getMetadata());
        }

        @Override
        public String getPlatformKey() {
            return this.platformKey;
        }

        @Override
        public Builder setPlatformKey(String platformKey) {
            this.platformKey = platformKey;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Collection<PlatformStream> getStreams() {
            return this.streams == null ? Collections.emptyList() : this.streams.values();
        }

        @Override
        @JsonIgnore
        public PlatformStream getStream(String id) {
            return this.streams == null ? null : this.streams.get(id);
        }

        @Override
        @JsonDeserialize(contentAs=PlatformStreamImpl.Builder.class)
        public Builder setStreams(Collection<PlatformStream> newStreams) {
            for (PlatformStream s : newStreams) {
                this.addStream(s);
            }
            return this;
        }

        @Override
        @JsonIgnore
        public Builder addStream(PlatformStream stream) {
            if (this.streams == null) {
                this.streams = new LinkedHashMap<String, PlatformStream>();
            }
            this.streams.put(stream.getId(), stream);
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, Object> metadata) {
            super.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setMetadata(String name, Object value) {
            super.setMetadata(name, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            super.removeMetadata(key);
            return this;
        }

        @Override
        public PlatformImpl build() {
            return new PlatformImpl(this);
        }

        public boolean equals(Object o) {
            return PlatformImpl.platformImplEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.platformKey);
        }

        public String toString() {
            return PlatformImpl.platformToString(this);
        }
    }
}

