/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalogImpl;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface ExtensionCatalog
extends ExtensionOrigin {
    public static final String MD_MINIMUM_JAVA_VERSION = "project.properties.minimum-java-version";
    public static final String MD_RECOMMENDED_JAVA_VERSION = "project.properties.recommended-java-version";

    public List<ExtensionOrigin> getDerivedFrom();

    public String getQuarkusCoreVersion();

    public String getUpstreamQuarkusCoreVersion();

    public Collection<Extension> getExtensions();

    public List<Category> getCategories();

    @Override
    default public Mutable mutable() {
        return new ExtensionCatalogImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        CatalogMapperHelper.serialize((Object)this, p);
    }

    public static Mutable builder() {
        return new ExtensionCatalogImpl.Builder();
    }

    public static ExtensionCatalog fromFile(Path path) throws IOException {
        return ExtensionCatalog.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        Mutable mutable = CatalogMapperHelper.deserialize(path, ExtensionCatalogImpl.Builder.class);
        return mutable == null ? ExtensionCatalog.builder() : mutable;
    }

    public static ExtensionCatalog fromStream(InputStream inputStream) throws IOException {
        Mutable mutable = CatalogMapperHelper.deserialize(inputStream, ExtensionCatalogImpl.Builder.class);
        return mutable == null ? ExtensionCatalog.builder().build() : mutable.build();
    }

    public static interface Mutable
    extends ExtensionCatalog,
    ExtensionOrigin.Mutable {
        @Override
        public Mutable setId(String var1);

        @Override
        public Mutable setPlatform(boolean var1);

        @Override
        public Mutable setBom(ArtifactCoords var1);

        public Mutable setQuarkusCoreVersion(String var1);

        public Mutable setUpstreamQuarkusCoreVersion(String var1);

        public Mutable setDerivedFrom(List<ExtensionOrigin> var1);

        public Mutable setExtensions(List<Extension> var1);

        public Mutable addExtension(Extension var1);

        public Mutable setCategories(List<Category> var1);

        public Mutable addCategory(Category var1);

        @Override
        public Mutable setMetadata(Map<String, Object> var1);

        @Override
        public Mutable setMetadata(String var1, Object var2);

        @Override
        public Mutable removeMetadata(String var1);

        @Override
        public ExtensionCatalog build();

        @Override
        default public void persist(Path p) throws IOException {
            CatalogMapperHelper.serialize((Object)this.build(), p);
        }
    }
}

