/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformImpl;
import io.quarkus.registry.json.JsonBuilder;
import io.quarkus.registry.json.JsonEntityWithAnySupport;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class PlatformCatalogImpl
extends JsonEntityWithAnySupport
implements PlatformCatalog {
    private final Map<String, Platform> platforms;

    public PlatformCatalogImpl(Builder builder) {
        super(builder);
        this.platforms = JsonBuilder.buildUnmodifiableMap(builder.platforms, LinkedHashMap::new);
    }

    @Override
    @JsonSerialize(contentAs=PlatformImpl.class)
    public Collection<Platform> getPlatforms() {
        return this.platforms.values();
    }

    @Override
    @JsonIgnore
    public Platform getPlatform(String platformId) {
        return this.platforms.get(platformId);
    }

    public boolean equals(Object o) {
        return PlatformCatalogImpl.platformCatalogEquals(this, o, this.platforms);
    }

    public int hashCode() {
        return Objects.hash(this.platforms);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{platforms=" + String.valueOf(this.platforms) + "}";
    }

    static final boolean platformCatalogEquals(PlatformCatalog c, Object o, Map<String, Platform> myPlatforms) {
        if (c == o) {
            return true;
        }
        if (o instanceof Builder) {
            return Objects.equals(myPlatforms, ((Builder)o).platforms);
        }
        if (o instanceof PlatformCatalogImpl) {
            return Objects.equals(myPlatforms, ((PlatformCatalogImpl)o).platforms);
        }
        if (!(o instanceof PlatformCatalog)) {
            return false;
        }
        PlatformCatalog that = (PlatformCatalog)o;
        return Objects.equals(c.getPlatforms(), that.getPlatforms());
    }

    public static class Builder
    extends JsonEntityWithAnySupport.Builder
    implements PlatformCatalog.Mutable {
        private Map<String, Platform> platforms;

        public Builder() {
        }

        Builder(PlatformCatalog source) {
            this.setMetadata((Map)source.getMetadata());
            this.setPlatforms((Collection)source.getPlatforms());
        }

        @Override
        public Builder addPlatform(Platform platform) {
            if (this.platforms == null) {
                this.platforms = new LinkedHashMap<String, Platform>();
            }
            this.platforms.put(platform.getPlatformKey(), platform);
            return this;
        }

        @Override
        public Collection<Platform> getPlatforms() {
            return this.platforms == null ? Collections.emptyList() : this.platforms.values();
        }

        @Override
        @JsonDeserialize(contentAs=PlatformImpl.Builder.class)
        public Builder setPlatforms(Collection<Platform> newValues) {
            for (Platform p : newValues) {
                this.addPlatform(p);
            }
            return this;
        }

        @Override
        @JsonIgnore
        public Platform getPlatform(String platformId) {
            return this.platforms == null ? null : this.platforms.get(platformId);
        }

        @Override
        public Builder setMetadata(Map<String, Object> metadata) {
            super.setMetadata(metadata);
            return this;
        }

        @Override
        public Builder setMetadata(String name, Object value) {
            super.setMetadata(name, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            super.removeMetadata(key);
            return this;
        }

        @Override
        public PlatformCatalogImpl build() {
            return new PlatformCatalogImpl(this);
        }

        public boolean equals(Object o) {
            return PlatformCatalogImpl.platformCatalogEquals(this, o, this.platforms);
        }

        public int hashCode() {
            return Objects.hash(this.platforms);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{platforms=" + String.valueOf(this.platforms) + "}";
        }
    }
}

