/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.selection.OriginWithPreference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class OriginCombination {
    private final OriginWithPreference[] collectedOrigins;

    public OriginCombination() {
        this.collectedOrigins = new OriginWithPreference[0];
    }

    private OriginCombination(OriginWithPreference[] selectedOrigins) {
        this.collectedOrigins = selectedOrigins;
    }

    private void sort() {
        Arrays.sort(this.collectedOrigins, new Comparator<OriginWithPreference>(){

            @Override
            public int compare(OriginWithPreference o1, OriginWithPreference o2) {
                return o1.getPreference().compareTo(o2.getPreference());
            }
        });
    }

    OriginCombination add(ArtifactKey extKey, OriginWithPreference origin) {
        for (OriginWithPreference selectedOrigin : this.collectedOrigins) {
            if (selectedOrigin.canBeCombinedWith(origin)) continue;
            return null;
        }
        return new OriginCombination(OriginCombination.addLast(this.collectedOrigins, origin));
    }

    List<OriginWithPreference> getCollectedOrigins() {
        return Arrays.asList(this.collectedOrigins);
    }

    public Collection<OriginWithPreference> getUniqueSortedOrigins() {
        if (this.collectedOrigins.length == 0) {
            return Collections.emptyList();
        }
        if (this.collectedOrigins.length == 1) {
            return Collections.singletonList(this.collectedOrigins[0]);
        }
        this.sort();
        ArrayList<OriginWithPreference> result = new ArrayList<OriginWithPreference>(this.collectedOrigins.length);
        result.add(this.collectedOrigins[0]);
        for (int i = 1; i < this.collectedOrigins.length; ++i) {
            OriginWithPreference o = this.collectedOrigins[i];
            if (((OriginWithPreference)result.get(result.size() - 1)).isSameAs(o)) continue;
            result.add(o);
        }
        return result;
    }

    public int size() {
        return this.collectedOrigins.length;
    }

    private static <T> T[] addLast(T[] arr, T item) {
        T[] copy = Arrays.copyOf(arr, arr.length + 1);
        copy[copy.length - 1] = item;
        return copy;
    }
}

