/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.util.GlobUtil;
import java.util.Objects;
import java.util.regex.Pattern;

class RegistryExtensionResolver {
    public static final int VERSION_NOT_RECOGNIZED = -1;
    public static final int VERSION_NOT_CONFIGURED = 0;
    public static final int VERSION_RECOGNIZED = 1;
    public static final int VERSION_EXCLUSIVE_PROVIDER = 2;
    private final RegistryConfig config;
    private final RegistryClient extensionResolver;
    private final int index;
    private Pattern recognizedQuarkusVersions;

    RegistryExtensionResolver(RegistryClient extensionResolver, MessageWriter log, int index) throws RegistryResolutionException {
        String versionExpr;
        this.extensionResolver = Objects.requireNonNull(extensionResolver, "Registry extension resolver is null");
        this.config = extensionResolver.resolveRegistryConfig();
        this.index = index;
        String string = versionExpr = this.config.getQuarkusVersions() == null ? null : this.config.getQuarkusVersions().getRecognizedVersionsExpression();
        if (versionExpr != null) {
            this.recognizedQuarkusVersions = Pattern.compile(GlobUtil.toRegexPattern(versionExpr));
        }
    }

    String getId() {
        return this.config.getId();
    }

    int getIndex() {
        return this.index;
    }

    int checkQuarkusVersion(String quarkusVersion) {
        if (this.recognizedQuarkusVersions == null) {
            return 0;
        }
        if (!this.recognizedQuarkusVersions.matcher(quarkusVersion).matches()) {
            return -1;
        }
        return this.config.getQuarkusVersions().isExclusiveProvider() ? 2 : 1;
    }

    boolean isExclusiveProviderOf(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) == 2;
    }

    boolean isAcceptsQuarkusVersionQueries(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) >= 0;
    }

    int checkPlatform(ArtifactCoords platform) {
        return this.checkQuarkusVersion(platform.getVersion());
    }

    PlatformCatalog resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    PlatformCatalog resolvePlatformCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        return this.extensionResolver.resolvePlatforms(quarkusCoreVersion);
    }

    Platform resolveRecommendedPlatform() throws RegistryResolutionException {
        return this.resolvePlatformCatalog().getRecommendedPlatform();
    }

    ExtensionCatalog resolveNonPlatformExtensions(String quarkusCoreVersion) throws RegistryResolutionException {
        return this.extensionResolver.resolveNonPlatformExtensions(quarkusCoreVersion);
    }

    ExtensionCatalog resolvePlatformExtensions(ArtifactCoords platform) throws RegistryResolutionException {
        return this.extensionResolver.resolvePlatformExtensions(platform);
    }

    void clearCache() throws RegistryResolutionException {
        this.extensionResolver.clearCache();
    }
}

