/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.json.JsonRegistryConfigDeserializer;
import io.quarkus.registry.config.json.JsonRegistryConfigSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class JsonRegistriesConfig
implements RegistriesConfig {
    private boolean debug;
    private List<RegistryConfig> registries = Collections.emptyList();

    @Override
    @JsonDeserialize(contentUsing=JsonRegistryConfigDeserializer.class)
    @JsonSerialize(contentUsing=JsonRegistryConfigSerializer.class)
    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    public void setRegistries(List<RegistryConfig> registries) {
        this.registries = registries == null ? Collections.emptyList() : registries;
    }

    public void addRegistry(RegistryConfig registry) {
        if (this.registries.isEmpty()) {
            this.registries = new ArrayList<RegistryConfig>();
        }
        this.registries.add(registry);
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.registries.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.debug, this.registries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonRegistriesConfig other = (JsonRegistriesConfig)obj;
        return this.debug == other.debug && Objects.equals(this.registries, other.registries);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (this.debug) {
            buf.append("debug ");
        }
        if (!this.registries.isEmpty()) {
            RegistryConfig r = this.registries.get(0);
            buf.append(r);
            for (int i = 1; i < this.registries.size(); ++i) {
                buf.append(", ").append(this.registries.get(i));
            }
        }
        return buf.append(']').toString();
    }
}

