/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.client.RegistryPlatformExtensionsResolver;
import io.quarkus.registry.client.maven.MavenRegistryArtifactResolver;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class MavenPlatformExtensionsResolver
implements RegistryPlatformExtensionsResolver {
    private final MavenRegistryArtifactResolver artifactResolver;
    private final MessageWriter log;

    public MavenPlatformExtensionsResolver(MavenRegistryArtifactResolver artifactResolver, MessageWriter log) {
        this.artifactResolver = Objects.requireNonNull(artifactResolver);
        this.log = Objects.requireNonNull(log);
    }

    @Override
    public ExtensionCatalog resolvePlatformExtensions(ArtifactCoords platformCoords) throws RegistryResolutionException {
        Path jsonPath;
        String version = platformCoords.getVersion() == null ? this.resolveLatestBomVersion(platformCoords, "[0-alpha,)") : (MavenPlatformExtensionsResolver.isVersionRange(platformCoords.getVersion()) ? this.resolveLatestBomVersion(platformCoords, platformCoords.getVersion()) : platformCoords.getVersion());
        String groupId = platformCoords.getGroupId();
        String artifactId = PlatformArtifacts.ensureCatalogArtifactId(platformCoords.getArtifactId());
        String classifier = version;
        DefaultArtifact catalogArtifact = new DefaultArtifact(groupId, artifactId, classifier, "json", version);
        this.log.debug("Resolving platform extension catalog %s", new Object[]{catalogArtifact});
        try {
            jsonPath = this.artifactResolver.resolve((Artifact)catalogArtifact);
        }
        catch (Exception e) {
            throw new RegistryResolutionException("Failed to resolve Quarkus extensions catalog " + (Artifact)catalogArtifact, e);
        }
        try {
            return JsonCatalogMapperHelper.deserialize(jsonPath, JsonExtensionCatalog.class);
        }
        catch (IOException e) {
            throw new RegistryResolutionException("Failed to parse Quarkus extensions catalog " + jsonPath, e);
        }
    }

    private String resolveLatestBomVersion(ArtifactCoords bom, String versionRange) throws RegistryResolutionException {
        DefaultArtifact bomArtifact = new DefaultArtifact(bom.getGroupId(), PlatformArtifacts.ensureBomArtifactId(bom.getArtifactId()), "", "pom", bom.getVersion());
        this.log.debug("Resolving the latest version of %s:%s:%s:%s in the range %s", new Object[]{bom.getGroupId(), bom.getArtifactId(), bom.getClassifier(), bom.getType(), versionRange});
        try {
            return this.artifactResolver.getLatestVersionFromRange((Artifact)bomArtifact, versionRange);
        }
        catch (Exception e) {
            throw new RegistryResolutionException("Failed to resolve the latest version of " + bomArtifact.getGroupId() + ":" + bom.getArtifactId() + ":" + bom.getClassifier() + ":" + bom.getType() + ":" + versionRange, e);
        }
    }

    private static boolean isVersionRange(String versionStr) {
        if (versionStr == null || versionStr.isEmpty()) {
            return false;
        }
        char c = versionStr.charAt(0);
        if (c == '[' || c == '(') {
            return true;
        }
        c = versionStr.charAt(versionStr.length() - 1);
        if (c == ']' || c == ')') {
            return true;
        }
        return versionStr.indexOf(44) >= 0;
    }
}

