/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.json.JsonCategory;
import io.quarkus.registry.catalog.json.JsonExtension;
import io.quarkus.registry.catalog.json.JsonExtensionOrigin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class JsonExtensionCatalog
extends JsonExtensionOrigin
implements ExtensionCatalog {
    private String quarkusCore;
    private String upstreamQuarkusCore;
    private List<ExtensionOrigin> derivedFrom;
    private List<Extension> extensions;
    private List<Category> categories;
    private Map<String, Object> metadata;

    @Override
    public String getQuarkusCoreVersion() {
        return this.quarkusCore;
    }

    public void setQuarkusCoreVersion(String quarkusCore) {
        this.quarkusCore = quarkusCore;
    }

    @Override
    public String getUpstreamQuarkusCoreVersion() {
        return this.upstreamQuarkusCore;
    }

    public void setUpstreamQuarkusCoreVersion(String upstreamQuarkusCore) {
        this.upstreamQuarkusCore = upstreamQuarkusCore;
    }

    @Override
    @JsonDeserialize(contentAs=JsonExtensionOrigin.class)
    public List<ExtensionOrigin> getDerivedFrom() {
        return this.derivedFrom == null ? Collections.emptyList() : this.derivedFrom;
    }

    public void setDerivedFrom(List<ExtensionOrigin> origins) {
        this.derivedFrom = origins;
    }

    @JsonDeserialize(contentAs=JsonExtension.class)
    public List<Extension> getExtensions() {
        return this.extensions == null ? Collections.emptyList() : this.extensions;
    }

    public void setExtensions(List<Extension> extensions) {
        this.extensions = extensions;
    }

    public void addExtension(Extension e) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        this.extensions.add(e);
    }

    @Override
    @JsonDeserialize(contentAs=JsonCategory.class)
    public List<Category> getCategories() {
        return this.categories == null ? Collections.emptyList() : this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public void addCategory(Category c) {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        this.categories.add(c);
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata == null ? Collections.emptyMap() : this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }
}

