/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionOrigin;
import java.util.List;
import java.util.Map;

public interface Extension {
    public static final String MD_SHORT_NAME = "short-name";
    public static final String MD_NESTED_CODESTART_NAME = "codestart.name";
    public static final String MD_NESTED_CODESTART_LANGUAGES = "codestart.languages";
    public static final String MD_NESTED_CODESTART_KIND = "codestart.kind";
    public static final String MD_NESTED_CODESTART_ARTIFACT = "codestart.artifact";
    public static final String MD_GUIDE = "guide";
    public static final String MD_KEYWORDS = "keywords";
    public static final String MD_UNLISTED = "unlisted";
    public static final String MD_CATEGORIES = "categories";
    public static final String MD_STATUS = "status";

    public String getName();

    public String getDescription();

    public ArtifactCoords getArtifact();

    public List<ExtensionOrigin> getOrigins();

    default public boolean hasPlatformOrigin() {
        List<ExtensionOrigin> origins = this.getOrigins();
        if (origins == null || origins.isEmpty()) {
            return false;
        }
        for (ExtensionOrigin o : origins) {
            if (!o.isPlatform()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getMetadata();

    default public String managementKey() {
        ArtifactCoords artifact = this.getArtifact();
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }
}

