/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.maven.model.Dependency;

public final class Extensions {
    private Extensions() {
    }

    public static ArtifactKey toKey(Extension extension) {
        return ArtifactKey.of((String)extension.getArtifact().getGroupId(), (String)extension.getArtifact().getArtifactId(), (String)extension.getArtifact().getClassifier(), (String)extension.getArtifact().getType());
    }

    public static ArtifactKey toKey(Dependency dependency) {
        return ArtifactKey.of((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getClassifier(), (String)dependency.getType());
    }

    public static Optional<Extension> findInList(Collection<Extension> list, ArtifactKey key) {
        return list.stream().filter(e -> Objects.equals(e.getArtifact().getKey(), key)).findFirst();
    }

    public static ArtifactCoords toCoords(ArtifactKey k, String version) {
        return ArtifactCoords.of((String)k.getGroupId(), (String)k.getArtifactId(), (String)k.getClassifier(), (String)k.getType(), (String)version);
    }

    @Deprecated
    public static ArtifactCoords toCoords(Extension e) {
        return e.getArtifact();
    }

    public static ArtifactCoords toCoords(Dependency d, String overrideVersion) {
        return Extensions.overrideVersion(Extensions.toCoords(d), overrideVersion);
    }

    public static String toGAV(ArtifactCoords c) {
        if (c.getVersion() == null) {
            return Extensions.toGA(c);
        }
        return c.getGroupId() + ":" + c.getArtifactId() + ":" + c.getVersion();
    }

    public static String toGA(ArtifactCoords c) {
        return c.getGroupId() + ":" + c.getArtifactId();
    }

    public static String toGA(ArtifactKey c) {
        return c.getGroupId() + ":" + c.getArtifactId();
    }

    public static String toGA(Extension e) {
        return e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId();
    }

    public static ArtifactCoords stripVersion(ArtifactCoords coords) {
        return Extensions.overrideVersion(coords, null);
    }

    public static ArtifactCoords overrideVersion(ArtifactCoords coords, String overrideVersion) {
        return ArtifactCoords.of((String)coords.getGroupId(), (String)coords.getArtifactId(), (String)coords.getClassifier(), (String)coords.getType(), (String)overrideVersion);
    }

    public static ArtifactCoords toCoords(Dependency d) {
        return ArtifactCoords.of((String)d.getGroupId(), (String)d.getArtifactId(), (String)d.getClassifier(), (String)d.getType(), (String)d.getVersion());
    }
}

