/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.update;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.state.ExtensionProvider;
import io.quarkus.devtools.project.state.ModuleState;
import io.quarkus.devtools.project.state.ProjectState;
import io.quarkus.devtools.project.state.TopExtensionDependency;
import io.quarkus.devtools.project.update.ExtensionMapBuilder;
import io.quarkus.devtools.project.update.ExtensionUpdateInfo;
import io.quarkus.devtools.project.update.PlatformInfo;
import io.quarkus.devtools.project.update.ProjectExtensionsUpdateInfo;
import io.quarkus.devtools.project.update.ProjectPlatformUpdateInfo;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public final class ProjectUpdateInfos {
    private ProjectUpdateInfos() {
    }

    public static ProjectExtensionsUpdateInfo resolveExtensionsUpdateInfo(ProjectState currentState, ProjectState recommendedState) {
        ProjectUpdateInfos.checkProjectState(currentState, recommendedState);
        ExtensionMapBuilder extensionInfo = new ExtensionMapBuilder(currentState.getExtensions().size());
        for (TopExtensionDependency dep : currentState.getExtensions()) {
            extensionInfo.add(new ExtensionMapBuilder.ExtensionUpdateInfoBuilder(dep));
        }
        for (TopExtensionDependency dep : recommendedState.getExtensions()) {
            ExtensionMapBuilder.ExtensionUpdateInfoBuilder info = extensionInfo.get(dep.getKey());
            if (info == null) continue;
            info.setRecommendedDep(dep);
        }
        LinkedHashMap<String, List<ExtensionUpdateInfo>> extensions = new LinkedHashMap<String, List<ExtensionUpdateInfo>>(0);
        for (ExtensionMapBuilder.ExtensionUpdateInfoBuilder infoBuilder : extensionInfo.values()) {
            ExtensionUpdateInfo info = infoBuilder.build();
            if (!info.isUpdateRecommended()) continue;
            extensions.computeIfAbsent(info.getRecommendedDependency().getProviderKey(), k -> new ArrayList()).add(info);
        }
        return new ProjectExtensionsUpdateInfo(extensions);
    }

    public static ProjectPlatformUpdateInfo resolvePlatformUpdateInfo(ProjectState currentState, ProjectState recommendedState) {
        ProjectUpdateInfos.checkProjectState(currentState, recommendedState);
        LinkedHashMap<ArtifactKey, PlatformInfo> platformImports = new LinkedHashMap<ArtifactKey, PlatformInfo>();
        for (ArtifactCoords c : currentState.getPlatformBoms()) {
            PlatformInfo info = new PlatformInfo(c, null);
            platformImports.put(c.getKey(), info);
        }
        ArrayList<PlatformInfo> importVersionUpdates = new ArrayList<PlatformInfo>();
        ArrayList<PlatformInfo> newImports = new ArrayList<PlatformInfo>(0);
        for (ArtifactCoords c : recommendedState.getPlatformBoms()) {
            PlatformInfo importInfo = platformImports.compute(c.getKey(), (k, v) -> {
                if (v == null) {
                    return new PlatformInfo(null, c);
                }
                return new PlatformInfo(v.getImported(), c);
            });
            if (importInfo.isToBeImported()) {
                newImports.add(importInfo);
                continue;
            }
            if (!importInfo.isVersionUpdateRecommended()) continue;
            importVersionUpdates.add(importInfo);
        }
        return new ProjectPlatformUpdateInfo(platformImports, importVersionUpdates, newImports);
    }

    private static void checkProjectState(ProjectState currentState, ProjectState recommendedState) {
        if (currentState.getPlatformBoms().isEmpty()) {
            throw new IllegalStateException("The project does not import any Quarkus platform BOM");
        }
    }

    public static ProjectState resolveRecommendedState(ProjectState currentState, ExtensionCatalog recommendedCatalog, MessageWriter log) {
        List<ExtensionCatalog> recommendedOrigins;
        if (currentState.getPlatformBoms().isEmpty()) {
            return currentState;
        }
        if (currentState.getExtensions().isEmpty()) {
            return currentState;
        }
        ExtensionMapBuilder builder = new ExtensionMapBuilder();
        for (TopExtensionDependency dep : currentState.getExtensions()) {
            builder.add(new ExtensionMapBuilder.ExtensionUpdateInfoBuilder(dep));
        }
        for (Extension e2 : recommendedCatalog.getExtensions()) {
            ExtensionMapBuilder.ExtensionUpdateInfoBuilder candidate = builder.get(e2.getArtifact().getKey());
            if (candidate == null || candidate.getLatestMetadata() != null) continue;
            candidate.setLatestMetadata(e2);
        }
        ArrayList<ExtensionMapBuilder.ExtensionUpdateInfoBuilder> unknownExtensions = new ArrayList<ExtensionMapBuilder.ExtensionUpdateInfoBuilder>(0);
        ArrayList<Extension> updateCandidates = new ArrayList<Extension>(builder.size());
        HashMap<String, ExtensionMapBuilder> updateCandidatesByOrigin = new HashMap<String, ExtensionMapBuilder>();
        for (ExtensionMapBuilder.ExtensionUpdateInfoBuilder i : builder.values()) {
            if (i.getLatestMetadata() == null) {
                unknownExtensions.add(i);
                continue;
            }
            updateCandidates.add(i.getLatestMetadata());
            for (ExtensionOrigin extensionOrigin : i.getLatestMetadata().getOrigins()) {
                updateCandidatesByOrigin.computeIfAbsent(extensionOrigin.getId(), k -> new ExtensionMapBuilder()).add(i);
            }
        }
        if (builder.isEmpty()) {
            return currentState;
        }
        if (!unknownExtensions.isEmpty()) {
            log.warn("The configured Quarkus registries did not provide any compatibility information for the following extensions in the context of the currently recommended Quarkus platforms:");
            unknownExtensions.forEach(e -> log.warn(" " + e.getCurrentDep().getArtifact().toCompactCoords()));
        }
        try {
            recommendedOrigins = ProjectUpdateInfos.getRecommendedOrigins(recommendedCatalog, updateCandidates);
        }
        catch (QuarkusCommandException e3) {
            log.warn("Failed to find a compatible configuration update for the project");
            return currentState;
        }
        int collectedUpdates = 0;
        block6: for (ExtensionCatalog extensionCatalog : recommendedOrigins) {
            ExtensionMapBuilder candidates = (ExtensionMapBuilder)updateCandidatesByOrigin.get(extensionCatalog.getId());
            for (Extension e4 : extensionCatalog.getExtensions()) {
                ExtensionMapBuilder.ExtensionUpdateInfoBuilder info = candidates.get(e4.getArtifact().getKey());
                if (info == null || info.getRecommendedMetadata() != null) continue;
                info.setRecommendedMetadata(e4);
                if (++collectedUpdates != updateCandidates.size()) continue;
                continue block6;
            }
        }
        ProjectState.Builder stateBuilder = ProjectState.builder();
        for (ExtensionCatalog c : recommendedOrigins) {
            if (!c.isPlatform()) continue;
            stateBuilder.addPlatformBom(c.getBom());
        }
        LinkedHashMap<String, ExtensionProvider.Builder> linkedHashMap = new LinkedHashMap<String, ExtensionProvider.Builder>(recommendedOrigins.size());
        for (ExtensionMapBuilder.ExtensionUpdateInfoBuilder info : builder.values()) {
            TopExtensionDependency ext = info.resolveRecommendedDep();
            stateBuilder.addExtensionDependency(ext);
            linkedHashMap.computeIfAbsent(ext.getProviderKey(), k -> ExtensionProvider.builder().setOrigin(ext.getOrigin())).addExtension(ext);
        }
        linkedHashMap.values().forEach(b -> stateBuilder.addExtensionProvider(b.build()));
        for (ModuleState module : currentState.getModules()) {
            ModuleState.Builder moduleBuilder = ModuleState.builder().setMainModule(module.isMain()).setWorkspaceModule(module.getWorkspaceModule());
            for (TopExtensionDependency dep : module.getExtensions()) {
                TopExtensionDependency recommendedDep = builder.get(dep.getKey()).resolveRecommendedDep();
                moduleBuilder.addExtensionDependency(recommendedDep);
                ExtensionOrigin origin = recommendedDep.getOrigin();
                if (origin == null || !origin.isPlatform()) continue;
                moduleBuilder.addPlatformBom(origin.getBom());
            }
            stateBuilder.addModule(moduleBuilder.build());
        }
        return stateBuilder.build();
    }

    private static List<ExtensionCatalog> getRecommendedOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensions) throws QuarkusCommandException {
        ArrayList<ExtensionOrigins> extOrigins = new ArrayList<ExtensionOrigins>(extensions.size());
        for (Extension e : extensions) {
            ProjectUpdateInfos.addOrigins(extOrigins, e);
        }
        OriginCombination recommendedCombination = OriginSelector.of(extOrigins).calculateRecommendedCombination();
        if (recommendedCombination == null) {
            StringBuilder buf = new StringBuilder();
            buf.append("Failed to determine a compatible Quarkus version for the requested extensions: ");
            buf.append(extensions.get(0).getArtifact().getKey().toGacString());
            for (int i = 1; i < extensions.size(); ++i) {
                buf.append(", ").append(extensions.get(i).getArtifact().getKey().toGacString());
            }
            throw new QuarkusCommandException(buf.toString());
        }
        return recommendedCombination.getUniqueSortedOrigins().stream().map(o -> o.getCatalog()).collect(Collectors.toList());
    }

    private static void addOrigins(List<ExtensionOrigins> extOrigins, Extension e) {
        ExtensionOrigins.Builder eoBuilder = null;
        for (ExtensionOrigin o : e.getOrigins()) {
            ExtensionCatalog c;
            OriginPreference op;
            if (!(o instanceof ExtensionCatalog) || (op = (OriginPreference)(c = (ExtensionCatalog)o).getMetadata().get("origin-preference")) == null) continue;
            if (eoBuilder == null) {
                eoBuilder = ExtensionOrigins.builder((ArtifactKey)e.getArtifact().getKey());
            }
            eoBuilder.addOrigin(c, op);
        }
        if (eoBuilder != null) {
            extOrigins.add(eoBuilder.build());
        }
    }
}

