/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.RemoveExtensionsCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;

public class RemoveExtensions {
    public static final String EXTENSIONS = "quarkus.remove-extensions.extensions";
    public static final String OUTCOME_UPDATED = "quarkus.remove-extensions.outcome-updated";
    public static final String EXTENSION_MANAGER = "quarkus.remove-extensions.extension-manager";
    private final QuarkusCommandInvocation invocation;

    public RemoveExtensions(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public RemoveExtensions(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public RemoveExtensions extensions(Set<String> extensions) {
        this.invocation.setValue(EXTENSIONS, extensions);
        return this;
    }

    public RemoveExtensions extensionManager(ExtensionManager extensionManager) {
        this.invocation.setValue(EXTENSION_MANAGER, Objects.requireNonNull(extensionManager, "extensionManager is required"));
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return new RemoveExtensionsCommandHandler().execute(this.invocation);
    }
}

