/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.descriptor;

import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.bootstrap.resolver.AppModelResolver;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.json.JsonCatalogMapperHelper;
import io.quarkus.registry.catalog.json.JsonExtensionCatalog;
import io.quarkus.registry.catalog.json.JsonExtensionOrigin;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ProjectPlatformDescriptorJsonUtil {
    public static JsonExtensionCatalog resolveCatalog(AppModelResolver resolver, List<AppArtifact> depConstraints) throws AppModelResolverException {
        ArrayList<JsonExtensionCatalog> platforms = new ArrayList<JsonExtensionCatalog>(2);
        HashSet<ArtifactKey> processedPlatforms = new HashSet<ArtifactKey>();
        for (int i = 0; i < depConstraints.size(); ++i) {
            JsonExtensionCatalog platform;
            AppArtifact artifact = depConstraints.get(i);
            if (!artifact.getArtifactId().endsWith("-quarkus-platform-descriptor") && !artifact.getType().equals("json") || !processedPlatforms.add(new ArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType()))) continue;
            Path json = resolver.resolve(artifact);
            try {
                platform = (JsonExtensionCatalog)JsonCatalogMapperHelper.deserialize((Path)json, JsonExtensionCatalog.class);
            }
            catch (IOException e) {
                throw new AppModelResolverException("Failed to deserialize a platform descriptor from " + json, (Throwable)e);
            }
            platform.getDerivedFrom().forEach(o -> processedPlatforms.add(ArtifactCoords.fromString((String)o.getId()).getKey()));
            platforms.add(platform);
        }
        if (platforms.isEmpty()) {
            return null;
        }
        ArrayList<JsonExtensionOrigin> derivedFrom = new ArrayList<JsonExtensionOrigin>();
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashSet<ArtifactKey> extensionKeys = new HashSet<ArtifactKey>();
        ArrayList<Category> categories = new ArrayList<Category>();
        HashSet<String> categoryIds = new HashSet<String>();
        HashMap metadata = new HashMap();
        JsonExtensionCatalog catalog = new JsonExtensionCatalog();
        catalog.setPlatform(false);
        catalog.setDerivedFrom(derivedFrom);
        catalog.setExtensions(extensions);
        catalog.setCategories(categories);
        catalog.setMetadata(metadata);
        JsonExtensionCatalog dominatingPlatform = (JsonExtensionCatalog)platforms.get(0);
        catalog.setQuarkusCoreVersion(dominatingPlatform.getQuarkusCoreVersion());
        catalog.setUpstreamQuarkusCoreVersion(dominatingPlatform.getUpstreamQuarkusCoreVersion());
        for (int i = 0; i < platforms.size(); ++i) {
            JsonExtensionCatalog platform = (JsonExtensionCatalog)platforms.get(i);
            if (platform.getBom() != null) {
                catalog.setBom(platform.getBom());
            }
            JsonExtensionOrigin origin = new JsonExtensionOrigin();
            origin.setId(platform.getId());
            origin.setPlatform(platform.isPlatform());
            origin.setBom(platform.getBom());
            derivedFrom.add(origin);
            for (Extension extension : platform.getExtensions()) {
                if (!extensionKeys.add(extension.getArtifact().getKey())) continue;
                extensions.add(extension);
            }
            for (Category category : platform.getCategories()) {
                if (!categoryIds.add(category.getId())) continue;
                categories.add(category);
            }
            for (Map.Entry entry : platform.getMetadata().entrySet()) {
                if (metadata.containsKey(entry.getKey())) continue;
                metadata.put((String)entry.getKey(), entry.getValue());
            }
        }
        return catalog;
    }
}

