/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipLong;

public final class QuarkusProjectCompress {
    private static final List<String> EXECUTABLES = Collections.unmodifiableList(Arrays.asList("gradlew", "gradlew.bat", "mvnw", "mvnw.bat"));
    static final int DIR_UNIX_MODE = 16877;

    private QuarkusProjectCompress() {
    }

    public static void zip(Path quarkusProjectDirPath, Path targetZipPath, boolean includeProjectDirectory) throws IOException {
        QuarkusProjectCompress.zip(quarkusProjectDirPath, targetZipPath, includeProjectDirectory, null);
    }

    public static void zip(Path quarkusProjectDirPath, Path targetZipPath, boolean includeProjectDirectory, Long withSpecificFilesTime) throws IOException {
        try (ZipArchiveOutputStream zaos = new ZipArchiveOutputStream(Files.newOutputStream(targetZipPath, new OpenOption[0]));
             Stream<Path> paths = Files.walk(quarkusProjectDirPath, new FileVisitOption[0]);){
            paths.filter(path -> includeProjectDirectory || !quarkusProjectDirPath.equals(path)).forEach(path -> {
                try {
                    int unixMode;
                    Object entryName = quarkusProjectDirPath.relativize((Path)path).toString().replace('\\', '/');
                    if (includeProjectDirectory) {
                        entryName = quarkusProjectDirPath.getFileName() + (String)(((String)entryName).length() == 0 ? "" : "/" + (String)entryName);
                    }
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        entryName = (String)entryName + "/";
                        unixMode = 16877;
                    } else {
                        unixMode = QuarkusProjectCompress.getFileUnixMode(QuarkusProjectCompress.isExecutable((String)entryName));
                    }
                    ZipArchiveEntry entry = new ZipArchiveEntry(path.toFile(), (String)entryName);
                    entry.setUnixMode(unixMode);
                    if (withSpecificFilesTime != null) {
                        entry.setExtraFields(new ZipExtraField[]{QuarkusProjectCompress.getTimestamp(withSpecificFilesTime)});
                    }
                    zaos.putArchiveEntry((ArchiveEntry)entry);
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        Files.copy(path, (OutputStream)zaos);
                    }
                    zaos.closeArchiveEntry();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    static int getFileUnixMode(boolean isExecutable) {
        return 0x8000 | (isExecutable ? 493 : 420);
    }

    static boolean isExecutable(String entryName) {
        return EXECUTABLES.stream().anyMatch(entryName::contains);
    }

    private static X5455_ExtendedTimestamp getTimestamp(long time) {
        X5455_ExtendedTimestamp timestamp = new X5455_ExtendedTimestamp();
        ZipLong zipTime = new ZipLong(time / 1000L);
        timestamp.setCreateTime(zipTime);
        timestamp.setModifyTime(zipTime);
        timestamp.setAccessTime(zipTime);
        return timestamp;
    }
}

