/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.tools;

import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.util.Properties;

public class ToolsUtils {
    public static String requireProperty(String name) {
        String value = ToolsUtils.getProperty(name);
        if (value == null) {
            throw new IllegalStateException("Failed to resolve required property " + name);
        }
        return value;
    }

    public static String getProperty(String name) {
        return ToolsUtils.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        return System.getProperty(name, defaultValue);
    }

    public static boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }

    public static String dotJoin(String ... parts) {
        if (parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(parts[0]);
        int i = 1;
        while (i < parts.length) {
            buf.append('.').append(parts[i++]);
        }
        return buf.toString();
    }

    public static Properties readQuarkusProperties(QuarkusPlatformDescriptor platformDescr) {
        Properties properties;
        try {
            properties = (Properties)platformDescr.loadResource("quarkus.properties", is -> {
                Properties props = new Properties();
                props.load(is);
                return props;
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read quarkus.properties", e);
        }
        return properties;
    }

    public static String getPluginArtifactId(Properties props) {
        return props.getProperty("plugin-artifactId");
    }

    public static String getPluginGroupId(Properties props) {
        return props.getProperty("plugin-groupId");
    }

    public static String getPluginVersion(Properties props) {
        return props.getProperty("plugin-version");
    }

    public static String getPluginKey(Properties props) {
        return ToolsUtils.getPluginGroupId(props) + ":" + ToolsUtils.getPluginArtifactId(props);
    }

    public static String getProposedMavenVersion(Properties props) {
        return props.getProperty("proposed-maven-version");
    }

    public static String getMavenWrapperVersion(Properties props) {
        return props.getProperty("maven-wrapper-version");
    }

    public static String getGradleWrapperVersion(Properties props) {
        return props.getProperty("gradle-wrapper-version");
    }
}

