/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.jbang;

import io.quarkus.devtools.codestarts.Codestart;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartPathLoader;
import io.quarkus.devtools.codestarts.CodestartProjectInput;
import io.quarkus.devtools.codestarts.QuarkusPlatformCodestartResourceLoader;
import io.quarkus.devtools.codestarts.core.GenericCodestartCatalog;
import io.quarkus.devtools.codestarts.jbang.QuarkusJBangCodestartProjectInput;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class QuarkusJBangCodestartCatalog
extends GenericCodestartCatalog<QuarkusJBangCodestartProjectInput> {
    public static final String QUARKUS_JBANG_CODESTARTS_DIR = "codestarts/quarkus-jbang";

    private QuarkusJBangCodestartCatalog(Collection<Codestart> codestarts) {
        super(codestarts);
    }

    public static QuarkusJBangCodestartCatalog fromQuarkusPlatformDescriptor(QuarkusPlatformDescriptor platformDescriptor) throws IOException {
        CodestartPathLoader pathLoader = QuarkusPlatformCodestartResourceLoader.platformPathLoader(platformDescriptor);
        List codestarts = CodestartCatalogLoader.loadCodestarts((CodestartPathLoader)pathLoader, (String)QUARKUS_JBANG_CODESTARTS_DIR, (String[])new String[0]);
        return new QuarkusJBangCodestartCatalog(codestarts);
    }

    protected Collection<Codestart> select(QuarkusJBangCodestartProjectInput projectInput) {
        if (projectInput.getDependencies().stream().anyMatch(s -> s.contains("quarkus-picocli"))) {
            projectInput.getSelection().addName("picocli");
        } else {
            projectInput.getSelection().addName("resteasy");
        }
        projectInput.getSelection().addNames(this.getToolingCodestarts(projectInput));
        return super.select((CodestartProjectInput)projectInput);
    }

    private List<String> getToolingCodestarts(QuarkusJBangCodestartProjectInput projectInput) {
        ArrayList<String> codestarts = new ArrayList<String>();
        if (!projectInput.noJBangWrapper()) {
            codestarts.add(Tooling.JBANG_WRAPPER.getKey());
        }
        return codestarts;
    }

    static interface KeySupplier {
        default public String getKey() {
            return this.toString().toLowerCase().replace("_", "-");
        }
    }

    public static enum Tooling implements KeySupplier
    {
        JBANG_WRAPPER;

    }
}

